/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.services;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.simantics.db.Session;
import org.simantics.db.adaption.AdaptionService;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.services.ServiceInitializer;
import org.simantics.db.services.adaption.AdapterRegistry2;
import org.simantics.db.services.adaption.AdaptionService2;
import org.simantics.db.services.internal.Activator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdaptionServiceInitializer
implements ServiceInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdaptionServiceInitializer.class);

    @Override
    public IStatus initialize(Session s) {
        LOGGER.info("Initializing");
        AdaptionService2 service = new AdaptionService2();
        s.registerService(AdaptionService.class, (Object)service);
        try {
            AdapterRegistry2 registry = new AdapterRegistry2();
            registry.initialize(Activator.getDefault().getContext());
            LOGGER.info("Updating");
            registry.updateAdaptionService(s, service);
            return Status.OK_STATUS;
        }
        catch (DatabaseException e) {
            Status status = new Status(4, "org.simantics.db.services", "AdaptionRegistry2 instantiation failed, see exception for details.", (Throwable)e);
            return status;
        }
    }
}

