package org.simantics.db.services.adaption.reflection;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.adaption.Adapter;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.AsyncProcedure;

public abstract class AbstractReflectionAdapter<T> implements Adapter<T,Resource>  {
    IDynamicAdapter2[] parameters;
    
    public AbstractReflectionAdapter(IDynamicAdapter2 ... parameters) throws SecurityException, NoSuchMethodException, DatabaseException {
        this.parameters = parameters;
    }
    
    public abstract void construct(AsyncReadGraph g, AsyncProcedure<T> procedure, Object ... args);
    
    @Override
    public void adapt(AsyncReadGraph g, final Resource source, final Resource r, final AsyncProcedure<T> procedure) {

        if(parameters.length == 0) {
            
//            System.out.println("ReflectionAdapter2 " + ReflectionAdapter2.this);
            construct(g, procedure);
            
        } else if( parameters.length == 1 && parameters[0] instanceof ThisResource2) {

            construct(g, procedure, r);
            
        } else {
        
            g.asyncRequest(new ReadRequest() {
    
                @Override
                public void run(ReadGraph graph) throws DatabaseException {
                    
//                    System.out.println("ReflectionAdapter2 " + ReflectionAdapter2.this);
                    
                    Object[] args = new Object[parameters.length];
                    for(int i=0;i<parameters.length;++i)
                        args[i] = parameters[i].adapt(graph, r);
                    construct(g, procedure, args);
                }
                
            });
        
        }
        
    }
}
