/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.server.internal;

import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.map.hash.TIntObjectHashMap;
import org.simantics.db.server.ProCoreException;
import org.simantics.db.server.internal.Method;
import org.simantics.db.server.internal.Util;

class MethodQueue {
    private TIntObjectHashMap<Method> methodMap = new TIntObjectHashMap();

    MethodQueue() {
    }

    public synchronized int size() {
        return this.methodMap.size();
    }

    public synchronized boolean isEmpty() {
        return this.size() == 0;
    }

    public synchronized void add(Method method) throws ProCoreException {
        int token = method.getToken();
        if (token == 0) {
            throw new ProCoreException("Illegal token number.");
        }
        Method oldMethod = (Method)this.methodMap.put(token, (Object)method);
        if (oldMethod != null) {
            throw new ProCoreException("Duplicate token number.");
        }
    }

    public synchronized Method remove(int token) {
        Method method = (Method)this.methodMap.remove(token);
        return method;
    }

    synchronized void close() {
        try {
            TIntObjectIterator iterator = this.methodMap.iterator();
            while (iterator.hasNext()) {
                iterator.advance();
                Method method = (Method)iterator.value();
                if (method == null) {
                    Util.logError("Null function in method queue.");
                }
                method.gotException("Method queue closing.");
            }
        }
        finally {
            this.methodMap.clear();
        }
    }
}

