/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.server.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class Activator
extends Plugin {
    public static final String PLUGIN_ID = "org.simantics.db.server";
    static Activator activator;
    private static final String ROOT = "/";

    public void start(BundleContext context) throws Exception {
        activator = this;
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        activator = null;
    }

    public static Activator get() {
        return activator;
    }

    public static File getRoot() throws FileNotFoundException, IOException {
        Bundle b = Activator.get().getBundle();
        URL source = FileLocator.find((Bundle)b, (IPath)new Path(ROOT), null);
        URL fileSource = FileLocator.toFileURL((URL)source);
        if (fileSource == source) {
            throw new FileNotFoundException("/could not be made available from bundle " + b.getSymbolicName());
        }
        File root = new File(fileSource.getFile());
        return root;
    }

    public static File getServerFolder() throws FileNotFoundException, IOException {
        String suffix = Activator.calculateSuffix();
        String name = Activator.getRoot() + File.separator + suffix;
        File folder = new File(name);
        if (!folder.isDirectory()) {
            String wd = new File(".").getAbsolutePath();
            throw new FileNotFoundException("No directory for " + name + " current directory=" + wd + ".");
        }
        return folder;
    }

    public static String getExeSuffix() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.startsWith("windows")) {
            return ".exe";
        }
        return "";
    }

    private static String calculateSuffix() throws FileNotFoundException {
        String osArch = System.getProperty("os.arch").toLowerCase();
        String osName = System.getProperty("os.name").toLowerCase();
        if (Activator.is64BitOS()) {
            if (osName.startsWith("windows")) {
                return "win32.x86_64";
            }
            if (osName.startsWith("linux")) {
                return "linux.x86_64";
            }
            if (osName.startsWith("darwin")) {
                return "darwin.x86_64";
            }
        } else if (osArch.equals("i386") || osArch.equals("i586") || osArch.equals("i686") || osArch.equals("x86")) {
            if (osName.startsWith("windows")) {
                return "win32.x86";
            }
            if (osName.startsWith("linux")) {
                return "linux.x86";
            }
        }
        throw new FileNotFoundException("Unsupported architecture " + osArch + " and/or operating system " + osName);
    }

    private static boolean is64BitOS() {
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            return System.getenv("ProgramFiles(x86)") != null;
        }
        return System.getProperty("os.arch").indexOf("64") != -1;
    }
}

