/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.internal.ClusterChange;
import fi.vtt.simantics.procore.internal.SessionImplSocket;
import java.io.IOException;
import org.simantics.db.Database;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.impl.ClusterSupport;
import org.simantics.db.impl.graph.DelayedWriteGraph;
import org.simantics.db.impl.graph.WriteGraphImpl;
import org.simantics.db.procore.cluster.ClusterImpl;
import org.simantics.db.procore.cluster.TestCluster;
import org.simantics.db.request.WriteTraits;
import org.simantics.db.service.ClusterUID;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.db.service.XSupport;
import org.simantics.utils.datastructures.Pair;

public class XSupportImpl
implements XSupport {
    private final boolean DEBUG = false;
    private final SessionImplSocket session;

    XSupportImpl(SessionImplSocket session) {
        this.session = session;
    }

    public void corruptPageTableAndDie() throws DatabaseException {
        this.execute("corruptPageTableAndDie");
    }

    public void corruptCluster(Resource r) throws DatabaseException {
        ClusterImpl cluster = this.getCluster(r);
        long clusterId = -1L;
        if (cluster.cc == null) {
            cluster.cc = new ClusterChange(this.session.clusterStream, cluster);
        }
        this.session.clusterStream.corruptCluster(cluster.cc, clusterId);
    }

    public int corruptClusterTable(long clusterId) throws DatabaseException {
        return this.session.clusterTable.makeProxy(ClusterUID.make((long)0L, (long)666L), clusterId).getClusterKey();
    }

    public void flushCluster(Resource r) throws ServiceException {
        this.session.writeSupport.flushCluster(r);
    }

    public void breakConnection() throws DatabaseException {
        throw new DatabaseException("XSupport.breakConnection not implemented.");
    }

    public void setClusterStreamOff(boolean setOff) throws DatabaseException {
        this.session.clusterTranslator.setStreamOff(setOff);
    }

    public int clearMetadataCache() throws DatabaseException {
        return this.session.graphSession.metadataCache.clear();
    }

    public <T> void commitAndContinue(WriteOnlyGraph wograph, WriteTraits wtraits) {
        if (wograph instanceof DelayedWriteGraph) {
            DelayedWriteGraph dw = (DelayedWriteGraph)wograph;
            dw.addCommitAndContinue();
        } else {
            this.session.state.commitAndContinue2((WriteGraphImpl)wograph.getService(WriteGraphImpl.class), this.session.clusterStream, wtraits);
        }
    }

    public boolean getImmutable(Resource resource) throws DatabaseException {
        if (!resource.isPersistent()) {
            return false;
        }
        ClusterImpl clusterImpl = this.getCluster(resource);
        return clusterImpl.getImmutable();
    }

    public void setImmutable(Resource resource, boolean immutable) throws DatabaseException {
        ClusterImpl clusterImpl = this.getCluster(resource);
        clusterImpl.setImmutable(immutable, (ClusterSupport)this.session.clusterTranslator);
    }

    private ClusterImpl getCluster(Resource resource) throws DatabaseException {
        if (resource == null) {
            return null;
        }
        int key = this.session.getService(SerialisationSupport.class).getTransientId(resource);
        return (ClusterImpl)this.session.clusterTranslator.getClusterByResourceKey(key);
    }

    public void setServiceMode(boolean allow, boolean create) {
        int newServiceMode = (allow ? 1 : 0) + (create ? 2 : 0);
        if (newServiceMode != this.session.serviceMode) {
            this.session.serviceMode = newServiceMode;
            this.session.writeSupport.flushCluster();
            this.session.clusterSetsSupport.clear();
        }
    }

    public Pair<Boolean, Boolean> getServiceMode() {
        return Pair.make((Object)((this.session.serviceMode & 1) == 1 ? 1 : 0), (Object)((this.session.serviceMode & 2) == 2 ? 1 : 0));
    }

    public Resource convertDelayedResourceToResource(Resource resource) {
        return DelayedWriteGraph.convertDelayedResource((Resource)resource);
    }

    public String execute(String command) throws DatabaseException {
        boolean transaction = true;
        try {
            this.session.state.startReadTransaction(Integer.MIN_VALUE);
        }
        catch (Throwable t) {
            Logger.defaultLogError((String)"Trying to muddle on.", (Throwable)t);
            transaction = false;
        }
        try {
            String string = this.session.graphSession.execute(command);
            return string;
        }
        finally {
            if (transaction) {
                this.session.state.stopReadTransaction();
            }
        }
    }

    public void testCluster(Session session) throws DatabaseException {
        TestCluster.test(session);
    }

    public ClusterUID[] listClusters() throws DatabaseException {
        return this.session.graphSession.listClusters();
    }

    public void deleteCluster(ClusterUID clusterUID) throws DatabaseException {
        ClusterImpl clusterImpl = this.session.clusterTable.getClusterByClusterUIDOrMakeProxy(clusterUID);
        this.session.clusterTranslator.setDeleted((Object)clusterImpl, true);
    }

    public void purge() throws DatabaseException {
        if (this.session == null) {
            return;
        }
        if (this.session.graphSession == null) {
            return;
        }
        Database db = this.session.graphSession.dbSession.getDatabase();
        db.purgeDatabase();
    }

    public boolean rolledback() {
        return this.session.graphSession.rolledback();
    }

    public boolean isClusterLoaded(ClusterUID clusterUID) throws DatabaseException {
        ClusterImpl clusterImpl = this.session.clusterTable.getClusterByClusterUIDOrMakeProxy(clusterUID);
        return clusterImpl.isLoaded();
    }

    public void saveQueries() throws DatabaseException {
        try {
            this.session.queryProvider2.save();
        }
        catch (IOException e) {
            throw new DatabaseException((Throwable)e);
        }
    }
}

