/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.internal.ClusterStream;
import fi.vtt.simantics.procore.internal.ClusterTable;
import fi.vtt.simantics.procore.internal.ResourceHandleImpl;
import fi.vtt.simantics.procore.internal.SessionImplSocket;
import fi.vtt.simantics.procore.internal.StatementHandleImpl;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.ClusterBase;
import org.simantics.db.impl.ClusterTraitsBase;
import org.simantics.db.impl.ResourceImpl;
import org.simantics.db.procore.cluster.ClusterImpl;
import org.simantics.db.service.ClusterBuilder;
import org.simantics.db.service.ClusterUID;

public class ClusterBuilderImpl
implements ClusterBuilder {
    private final ClusterTable clusterTable;
    private final ClusterStream stream;
    private final SessionImplSocket.WriteOnlySupport support;

    ClusterBuilderImpl(SessionImplSocket session, SessionImplSocket.WriteOnlySupport support) {
        this.support = support;
        this.stream = support.stream;
        this.clusterTable = session.clusterTable;
    }

    public void newCluster() throws DatabaseException {
        this.support.flushCluster();
    }

    public ClusterBuilder.ResourceHandle newResource() throws DatabaseException {
        return new ResourceHandleImpl(this.support);
    }

    public ClusterBuilder.ResourceHandle resource(Resource res) throws DatabaseException {
        ResourceImpl r = (ResourceImpl)res;
        int clusterKey = ClusterTraitsBase.getClusterKeyFromResourceKey((int)r.id);
        ClusterBase cluster = this.clusterTable.getClusterByClusterKey(clusterKey);
        return new ResourceHandleImpl(this.stream, (ClusterImpl)cluster, r.id);
    }

    public ClusterBuilder.StatementHandle newStatement(ClusterBuilder.ResourceHandle predicate, ClusterBuilder.ResourceHandle object) throws DatabaseException {
        ResourceHandleImpl p = (ResourceHandleImpl)predicate;
        ResourceHandleImpl o = (ResourceHandleImpl)object;
        short pResourceIndex = ClusterTraitsBase.getResourceIndexFromResourceKey((int)p.resourceKey);
        ClusterBase pCluster = this.clusterTable.getClusterByClusterKey(pResourceIndex);
        ClusterUID pClusterUID = pCluster.getClusterUID();
        short oResourceIndex = ClusterTraitsBase.getResourceIndexFromResourceKey((int)p.resourceKey);
        ClusterBase oCluster = this.clusterTable.getClusterByClusterKey(oResourceIndex);
        ClusterUID oClusterUID = oCluster.getClusterUID();
        return new StatementHandleImpl(p.resourceKey, 0, o.resourceKey, 0, pClusterUID, oClusterUID);
    }
}

