/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.procore.cluster;

import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.ClusterI;
import org.simantics.db.impl.ClusterTraitsBase;


public final class ClusterTraitsSmall extends ClusterTraitsBase {
    static final short FOREIGN_INDEX_BITS = 15;
    static final short FOREIGN_INDEX_MAX = (1<<FOREIGN_INDEX_BITS)-1;
    static final int VALUE_INDEX_BITS = 22;
    static final int VALUE_INDEX_MAX = (1<<VALUE_INDEX_BITS)-1;
    static final int VALUE_INDEX_EX = VALUE_INDEX_MAX; 
    static final int VALUE_SIZE_BITS = 15;
    public static final int VALUE_SIZE_MAX = (1<<VALUE_SIZE_BITS)-1;
    public static final short makeForeignRef(short foreignIndex) {
        assert(foreignIndex <= FOREIGN_INDEX_MAX);
        return (short)(foreignIndex | 1<<FOREIGN_INDEX_BITS);
    }
    public static short resourceRefGetForeignIndex(short resourceRef)
    throws DatabaseException {
        if (resourceRef >>> FOREIGN_INDEX_BITS == 0)
            throw new DatabaseException("Local resource refence doesn't have foreing index. reference=" + resourceRef);
        return (short)(resourceRef & FOREIGN_INDEX_MAX);
    }
    public static boolean resourceRefIsLocal(short resourceRef) {
        return resourceRef > 0; 
    }
    public static ClusterI.CompleteTypeEnum completeRefAndTypeGetType(int completeRefAndType) {
        return ClusterI.CompleteTypeEnum.make((completeRefAndType >>> 16) & 0x3);
    }
    public static short completeRefAndTypeGetRef(int completeRefAndType) {
        return (short)(completeRefAndType & (1<<16)-1);
    }
}

