/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.procore.cluster;

import org.simantics.db.service.ClusterUID;


public interface ClusterChangeSetI {
    enum OperationEnum {
        Null,
        CreateResource,
        AddRelation,
        RemoveRelation,
        SetValue,
        DeleteValue,
        ModifyValue,
        EndOf;
    }
    public static class Operation {
           ClusterChangeSet.IteratorI iterator; // Position of the iteration. Do not mess with this.
           public OperationEnum type;
           public int count; // number of arguments
           public short resourceIndex;
           public short predicateIndex;
           public ClusterUID predicateCluster;
           public short objectIndex;
           public ClusterUID objectCluster;
           public long valueOffset;
           public int valueSize;
           public byte[] valueData; // The actual byte table where value data is. Do not mess with this.
           public int valueStart; // Start of value in valueData.
           public long cs;
           public long prevCs;
    };
    public void getNextOperation(Operation operation); // Skips unasked arguments.
	public ClusterUID getClusterUID();
}
