/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package fi.vtt.simantics.procore.internal;



//public abstract class ResourceImpl implements Resource {
//    public final static ResourceImpl[] NONE = new ResourceImpl[0];
//}

//class ResourceProxy {
//    private final int offset;
//    private final int size;
//    private WeakReference<ResourceImpl> weakResource = null; 
//    private ResourceImplModified modifiedResourceImpl = null;
//    private Value_ value;
//    ResourceProxy(int offset, int size) {
//        this.offset = offset;
//        this.size = size;
//    }
//    boolean isNew() {
//        return 0 == size;
//    }
//    private ResourceImpl getResourceImplModified(Cluster cluster, long subject) {
//        ResourceImpl r;
//        if (null == weakResource || null == (r = weakResource.get())) {
//            if (null == modifiedResourceImpl)
//                modifiedResourceImpl = new ResourceImplModified(cluster, offset, size, value);
//            r = new ResourceImpl(subject, modifiedResourceImpl);
//            weakResource = new WeakReference<ResourceImpl>(r); 
//        } else if (!r.isModified()) {
//            if (null == modifiedResourceImpl)
//                modifiedResourceImpl = new ResourceImplModified(cluster, offset, size, value);
//            r.setImpl(modifiedResourceImpl);
//        }
//        return r;
//    }
//    void setValue(Value_ value) {
//        this.value = value;
//    }
//    ResourceImpl addRelation(Cluster cluster, long subject, long predicate, long predicateCluster, long object, long objectCluster) {
//        ResourceImpl r = getResourceImplModified(cluster, subject);
//        return r.addRelation(predicate, predicateCluster, object, objectCluster);
//    }
//    void removeRelation(Cluster cluster, long subject, long predicate, long predicateCluster, long object, long objectCluster) throws StatementNotFoundException {
//        ResourceImpl r = getResourceImplModified(cluster, subject);
//        r.removeRelation(predicate, predicateCluster, object, objectCluster);
//    }
//    ResourceImpl getResource(Cluster cluster, long id) {
//        ResourceImpl r;
//        if (null != weakResource) {
//            r = weakResource.get();
//            if (null != r)
//                return r;
//        }
//        if (isNew()) {
//            if (null == modifiedResourceImpl)
//                modifiedResourceImpl = new ResourceImplModified(cluster, offset, size, value);
//            r = new ResourceImpl(id, modifiedResourceImpl);
//        } else
//            r = new ResourceImpl(id, new ResourceImplFixed(cluster, offset, size, value));
//        weakResource = new WeakReference<ResourceImpl>(r); 
//        return r;
//    }
//    ResourceImpl getResourceImpl(long id, ResourceImplModified impl) {
//        ResourceImpl r;
//        assert(null == modifiedResourceImpl);
//        assert(null == weakResource);
//        modifiedResourceImpl = impl;
//        r = new ResourceImpl(id, impl);
//        weakResource = new WeakReference<ResourceImpl>(r); 
//        return r;
//    }
//    void release() {
//        if (null == weakResource)
//            return;
//        weakResource = null;
//        modifiedResourceImpl = null;
//    }
//}
//
//abstract class ResourceImplAbstract {
//    abstract void init(ResourceImpl self);
//    abstract void dispose();
//    abstract Value_ getValue(ResourceImpl self);
//    abstract long getClusterId();
//    abstract boolean isModified();
//    abstract int getNumberOfRelations(ResourceImpl self);
//    abstract StatementImpl[] getStatements(ResourceImpl self) throws ResourceNotFoundException;
//    abstract void addRelation(ResourceImpl self, long predicate, long predicateCluster, long object, long objectCluster);
//    abstract void removeRelation(long predicate, long predicateCluster, long object, long objectCluster) throws StatementNotFoundException;
//    abstract void addValue(ResourceImpl self, Value_ value); // TODO: Remove return value, inefficient.
//}
//
//abstract class ResourceImplCluster extends ResourceImplAbstract {
//    private Cluster cluster;
//    protected Value_ value;
//    protected Value_ valueOld = null;
//    protected Cluster getCluster() {
//        return cluster;
//    }
//    ResourceImplCluster(Cluster cluster) {
//        this.cluster = cluster;
//        cluster.incReferenceCount();
//    }
//    void setCluster(Cluster c) {
//        this.cluster = c;
//    }
//    @Override
//    void init(ResourceImpl self) {
//    }
//    @Override
//    void dispose() {
//        cluster.decReferenceCount();
//    }
//    @Override
//    long getClusterId() {
//        return cluster.getId();
//    }
//    @Override
//    Value_ getValue(ResourceImpl self) {
//        return value;
//    }
//    protected void setValue(Value_ value) {
//        this.value = this.valueOld = value;
//    }
//    void moveValue() {
//        valueOld = value;
//    }
//    void removeValue() {
//        value = valueOld;
//    }
//    void addValue(ResourceImpl self, Value_ value) { // TODO: Remove return value, inefficient.
//        this.value = value;
//    }
//}
//
//class ResourceImplFixed extends ResourceImplCluster {
//    final int fixedOffset;
//    final int fixedSize;
//    public ResourceImplFixed(Cluster cluster, int offset, int size, Value_ value) {
//        super(cluster);
//        this.fixedOffset = offset;
//        this.fixedSize = size;
//        setValue(value);
//    }
//    @Override
//    int getNumberOfRelations(ResourceImpl self) {
//        return fixedSize;
//    }
//    @Override
//    StatementImpl[] getStatements(ResourceImpl self) throws ResourceNotFoundException {
//        StatementImpl[] stms = new StatementImpl[fixedSize];
//        GraphSession gs = this.getCluster().client;
//        int end = fixedOffset + fixedSize;
//        for (int i=fixedOffset, j=0; i<end; ++i, ++j) {
//            ResourceImpl p = gs.getResourceOrThrow(getCluster().raw.predicates[i], getCluster().raw.predicateClusters[i]);
//            stms[j] = new StatementImplNew(self, p, getCluster().raw.objects[i], getCluster().raw.objectClusters[i], gs);
////            ResourceImpl o = gs.getResourceOrThrow(getCluster().raw.objects[i], getCluster().raw.objectClusters[i]);
////            stms[j] = new StatementImplOld(self, p, o);
//        }
//        return stms;
//    }
//    @Override
//    boolean isModified() {
//        return false;
//    }
//    @Override
//    void addRelation(ResourceImpl self, long predicate, long predicateCluster, long object, long objectCluster) {
//        throw new Error("Not allowed");
//    }
//    @Override
//    void removeRelation(long predicate, long predicateCluster, long object, long objectCluster) {
//        throw new Error("Not allowed");
//    }
//}
//
//class ResourceImplModifiedStatement {
//    long predicate;
//    long predicateCluster;
//    long object;
//    long objectCluster;
//    ResourceImplModifiedStatement(long predicate, long predicateCluster, long object, long objectCluster) {
//        this.predicate = predicate;
//        this.predicateCluster = predicateCluster;
//        this.object = object;
//        this.objectCluster = objectCluster;
//    }
//    @Override
//    public int hashCode() {
//        return (int)(object^(object>>32)^predicate^(predicate>>>32));
//    }
//    @Override
//    public boolean equals(Object obj) {
//        if (this == obj)
//            return true;
//        else if (obj == null)
//            return false;
//        else if (ResourceImplModifiedStatement.class != obj.getClass())
//            return false;
//        ResourceImplModifiedStatement d = (ResourceImplModifiedStatement)obj;
//        return (d.object == object) && (d.predicate == predicate);
//    }
//}
//
//class ResourceImplModified extends ResourceImplCluster {
//    static ResourceImplModifiedStatement findStatement = new ResourceImplModifiedStatement(0, 0, 0, 0);
//    THashSet<ResourceImplModifiedStatement> statements = new THashSet<ResourceImplModifiedStatement>();
//    THashSet<ResourceImplModifiedStatement> reclusteringStatements = new THashSet<ResourceImplModifiedStatement>();
//    public ResourceImplModified(Cluster cluster, int offset, int size, Value_ value) {
//        super(cluster);
//        setValue(value);
//        statements.ensureCapacity(size);
//        for (int i=0,j=offset; i<size; ++i,++j) {
//            assert(Constants.ReservedClusterId != cluster.raw.predicateClusters[j]);
//            assert(Constants.ReservedClusterId != cluster.raw.objectClusters[j]);
//            statements.add(new ResourceImplModifiedStatement(cluster.raw.predicates[j], cluster.raw.predicateClusters[j], cluster.raw.objects[j], cluster.raw.objectClusters[j]));
//        }
//    }
//    void moveStatements(HashMap<Long, Long> oldResourceIdToNewClusterIdMap) {
//        for (ResourceImplModifiedStatement s : reclusteringStatements) {
//            statements.remove(s);
//            if (Constants.ReservedClusterId == s.predicateCluster)
//                s.predicateCluster = oldResourceIdToNewClusterIdMap.get(s.predicate);
//            if (Constants.ReservedClusterId == s.objectCluster)
//                s.objectCluster = oldResourceIdToNewClusterIdMap.get(s.object);
//            statements.add(s);
//        }
//        reclusteringStatements.clear();
//    }
//
//    void removeStatements() {
//        for (ResourceImplModifiedStatement s : reclusteringStatements) {
//            statements.remove(s);
//        }
//        reclusteringStatements.clear();
//    }
//
//    @Override
//    int getNumberOfRelations(ResourceImpl self) {
//        return statements.size();
//    }
//    @Override
//    boolean isModified() {
//        return true; // HACK: This is not necessarily true. In creation no modifications given and modifications can cancel each other out.
//    }
//    @Override
//    StatementImpl[] getStatements(ResourceImpl self) throws ResourceNotFoundException {
//        int size = statements.size();
//        StatementImpl[] stms = new StatementImpl[size];
//        GraphSession gs = getCluster().client;
//        int i = -1;
//        for (ResourceImplModifiedStatement s : statements) {
//            ResourceImpl p;
//            if (Constants.ReservedClusterId == s.predicateCluster)
//                p = this.getCluster().getResourceReservedOrThrow(Constants.ReservedClusterId, s.predicate);
//            else
//                p = gs.getResourceOrThrow(s.predicate, s.predicateCluster);
//            if (Constants.ReservedClusterId == s.objectCluster) {
//                ResourceImpl o = this.getCluster().getResourceReservedOrThrow(Constants.ReservedClusterId, s.object);
//                stms[++i] = new StatementImplOld(self, p, o);
//            } else
//                stms[++i] = new StatementImplNew(self, p, s.object, s.objectCluster, gs);
//        }
//        return stms;
//    }
//    private boolean find(long predicate, long predicateCluster, long object, long objectCluster) {
//        findStatement.predicate = predicate;
//        findStatement.predicateCluster = predicateCluster;
//        findStatement.object = object;
//        findStatement.objectCluster = objectCluster;
//        return statements.contains(findStatement);
//    }
//    @Override
//    void addRelation(ResourceImpl self, long predicate, long predicateCluster, long object, long objectCluster) {
//        if (find(predicate, predicateCluster, object, objectCluster))
//            return;
//        //System.out.println(self + "." + getNumberOfRelations(self) + ": " + predicate + "." + predicateCluster + " " + object + "." + objectCluster);
//        ResourceImplModifiedStatement s = new ResourceImplModifiedStatement(predicate, predicateCluster, object, objectCluster);
//        statements.add(s);
//        if (Constants.ReservedClusterId == predicateCluster ||
//                Constants.ReservedClusterId == objectCluster) {
//            reclusteringStatements.add(s);
//            getCluster().addModifiedResource(self);
//        }
//    }
//    @Override
//    void removeRelation(long predicate, long predicateCluster, long object, long objectCluster) throws StatementNotFoundException {
//        findStatement.predicate = predicate;
//        findStatement.predicateCluster = predicateCluster;
//        findStatement.object = object;
//        findStatement.objectCluster = objectCluster;
//        if (!statements.remove(findStatement))
//            throw new StatementNotFoundException();
//        reclusteringStatements.remove(findStatement);
//    }
//}
//
//class ResourceImplChangeSet extends ResourceImplAbstract {
//    private SessionImplHistorical session;
//    private long cluster;
//    private ResourceImpl original;
//    public ResourceImplChangeSet(SessionImplHistorical session, long cluster) {
//        this.session = session;
//        this.cluster = cluster;
//    }
//    @Override
//    void init(ResourceImpl self) {
//        Cluster c = session.getCluster(cluster);
//        if (null != c)
//            this.original = c.getResource(self.id);
//    }
//    @Override
//    void dispose() {
//    }
//    @Override
//    long getClusterId() {
//        return cluster;
//    }
//    @Override
//    Value_ getValue(ResourceImpl self) {
//        Value_ value = null;
//        if (null != original)
//            value = original.getValue();
//        return session.getValue(self.id, value);
//    }
//    @Override
//    int getNumberOfRelations(ResourceImpl self) {
//        int n = 0;
//        if (null != original)
//            n = original.getNumberOfRelations();
//        n += session.getNumberOfAddedRelations(self.id);
//        n -= session.getNumberOfRemovedRelations(self.id);
//        return n;
//    }
//    @Override
//    StatementImpl[] getStatements(ResourceImpl self) throws ResourceNotFoundException {
//        StatementImpl[] stms = StatementImpl.NONE;
//        if (null != original)
//            stms = original.getStatements();
//        return session.getStatements(self.id, stms);
//    }
//    @Override
//    boolean isModified() {
//        return false;
//    }
//    @Override
//    void addValue(ResourceImpl self, Value_ value) {
//        throw new Error("Not allowed");
//    }
//    @Override
//    void addRelation(ResourceImpl self, long predicate, long predicateCluster, long object, long objectCluster) {
//        throw new Error("Not allowed");
//    }
//    @Override
//    void removeRelation(long predicate, long predicateCluster, long object, long objectCluster) {
//        throw new Error("Not allowed");
//    }
//}
//
//class ResourceImplClusterNew extends ResourceImplAbstract {
//    //private Cluster clusterOld;
//	private final long id;
//    private org.simantics.db.procore.cluster.Cluster cluster;
//    protected Cluster getCluster() {
//        throw new Error("No can do.");
//    }
//    ResourceImplClusterNew(long id, org.simantics.db.procore.cluster.Cluster cluster) {
//        this.id = id;
//        this.cluster = cluster;
//    }
//    final org.simantics.db.procore.cluster.Cluster getClusterNew() {
//    	return cluster;
//    }
//    void setCluster(Cluster c) {
//        throw new Error("No can do.");
//    }
//    @Override
//    void init(ResourceImpl self) {
//    }
//    @Override
//    void dispose() {
//    }
//    @Override
//    long getClusterId() {
//        return cluster.getId();
//    }
//    @Override
//    Value_ getValue(ResourceImpl self) {
//    	byte[] value = cluster.getValue(id);
//    	return new Zany(value);
//    }
//    protected void setValue(Value_ value) {
//    	throw new Error("No can do.");
//    }
//    void moveValue() {
//    	throw new Error("No can do.");
//    }
//    void removeValue() {
//    	throw new Error("No can do.");
//    }
//    void addValue(ResourceImpl self, Value_ value) { // TODO: Remove return value, inefficient.
//    	throw new Error("No can do.");
//    }
//	@Override
//	void addRelation(ResourceImpl self, long predicate, long predicateCluster,
//			long object, long objectCluster) {
//		throw new Error("No can do.");
//	}
//	@Override
//	int getNumberOfRelations(ResourceImpl self) {
//		throw new Error("No can do.");
//	}
//	@Override
//	StatementImpl[] getStatements(ResourceImpl self) {
//		throw new Error("No can do.");
//	}
//	@Override
//	boolean isModified() {
//		throw new Error("No can do.");
//	}
//	@Override
//	void removeRelation(long predicate, long predicateCluster, long object,
//			long objectCluster) throws StatementNotFoundException {
//		throw new Error("No can do.");
//	}
//}
