package fi.vtt.simantics.procore.internal;

import java.util.HashSet;
import java.util.Set;

import org.simantics.db.impl.query.CacheEntry;
import org.simantics.db.impl.query.CacheEntryBase;
import org.simantics.db.impl.service.QueryDebug;
import org.simantics.db.request.AsyncMultiRead;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.request.MultiRead;
import org.simantics.db.request.Read;

public class QueryDebugImpl implements QueryDebug {
	
	final private SessionImplSocket session;
	
	QueryDebugImpl(SessionImplSocket session) {
		this.session = session;
	}

    @Override
    public Set<CacheEntry> getParents(AsyncRead<?> request) {
        HashSet<CacheEntry> result = new HashSet<CacheEntry>();
        CacheEntryBase<?> entry = session.queryProvider2.cache.entryAsyncRead(session.queryProvider2, request);
        if(entry != null) {
            for(CacheEntry parent : entry.getParents(session.queryProvider2)) result.add(parent);
        }
        return result;
    }

    @Override
    public Set<CacheEntry> getParents(AsyncMultiRead<?> request) {
        HashSet<CacheEntry> result = new HashSet<CacheEntry>();
        CacheEntryBase<?> entry = session.queryProvider2.cache.entryAsyncMultiRead(session.queryProvider2, request);
        if(entry != null) {
            for(CacheEntry parent : entry.getParents(session.queryProvider2)) result.add(parent);
        }
        return result;
    }

    @Override
    public Set<CacheEntry> getParents(Read<?> request) {
        HashSet<CacheEntry> result = new HashSet<CacheEntry>();
        CacheEntryBase<?> entry = session.queryProvider2.cache.entryRead(session.queryProvider2, request);
        if(entry != null) {
            for(CacheEntry parent : entry.getParents(session.queryProvider2)) result.add(parent);
        }
        return result;
    }

    @Override
    public Set<CacheEntry> getParents(MultiRead<?> request) {
        HashSet<CacheEntry> result = new HashSet<CacheEntry>();
        CacheEntryBase<?> entry = session.queryProvider2.cache.entryMultiRead(session.queryProvider2, request);
        if(entry != null) {
            for(CacheEntry parent : entry.getParents(session.queryProvider2)) result.add(parent);
        }
        return result;
    }

}
