/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.management;


/**
 * @author Tuukka Lehtonen
 */
public interface ISessionContextProviderSource {

    /**
     * @param context the context object of the requested ISessionContextProvider
     * @return <code>null</code> if there is no provider for the specified context
     */
    ISessionContextProvider get(Object context);

    /**
     * @return the currently active session context provider. Must always return
     *         a valid provider.
     */
    ISessionContextProvider getActive();

    /**
     * @return all currently existing session context providers 
     */
    ISessionContextProvider[] getAll();

    /**
     * Used for manually installing ISessionContextProvider for a specified
     * context handle object.
     * 
     * @param context the context handle to associate the session context
     *        provider to. This same argument needs to be used with
     *        {@link #get(Object)} when retrieving your session context
     *        provider.
     * @param provider the session context provider to associate with the
     *        specified context
     */
    void put(Object context, ISessionContextProvider provider);

    /**
     * Used for manually removing an (context, provider) association from this
     * source. Only associations created with
     * {@link #put(Object, ISessionContextProvider)} can be removed with this
     * method.
     * 
     * @param context the context handle to associate the session context
     *        provider to.
     * @return the dissociated session context provider
     */
    ISessionContextProvider remove(Object context);
    
}
