/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.variable;

import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.DatatypeNotFoundException;
import org.simantics.db.layer0.exception.MissingVariableValueException;
import org.simantics.db.layer0.exception.NonWritableVariableException;
import org.simantics.db.layer0.variable.ValueAccessor;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.scl.runtime.function.Function2;
import org.simantics.scl.runtime.function.Function3;

public class SCLValueAccessor
implements ValueAccessor {
    private final Function1<Variable, Object> getValue1;
    private final Function2<Variable, Binding, Object> getValue2;
    private final Function2<Variable, Object, Object> setValue2;
    private final Function3<Variable, Object, Binding, Object> setValue3;
    private final Function1<Variable, Datatype> getDatatype;

    public SCLValueAccessor(Function1<Variable, Object> getValue1, Function2<Variable, Binding, Object> getValue2, Function2<Variable, Object, Object> setValue2, Function3<Variable, Object, Binding, Object> setValue3, Function1<Variable, Datatype> getDatatype) {
        this.getValue1 = getValue1;
        this.getValue2 = getValue2;
        this.setValue2 = setValue2;
        this.setValue3 = setValue3;
        this.getDatatype = getDatatype;
    }

    @Override
    public Object getValue(ReadGraph graph, Variable context) throws DatabaseException {
        SCLContext sclContext = SCLContext.getCurrent();
        Object oldGraph = sclContext.put((Object)"graph", (Object)graph);
        try {
            Object object = this.getValue1.apply((Object)context);
            return object;
        }
        catch (Throwable t) {
            throw new MissingVariableValueException("Could not get value for " + String.valueOf(context.getRepresents(graph)), t);
        }
        finally {
            sclContext.put((Object)"graph", oldGraph);
        }
    }

    @Override
    public Object getValue(ReadGraph graph, Variable context, Binding binding) throws DatabaseException {
        SCLContext sclContext = SCLContext.getCurrent();
        Object oldGraph = sclContext.put((Object)"graph", (Object)graph);
        try {
            Object object = this.getValue2.apply((Object)context, (Object)binding);
            return object;
        }
        catch (Throwable t) {
            throw new MissingVariableValueException("Could not get value for " + String.valueOf(context.getRepresents(graph)) + " with binding " + binding, t);
        }
        finally {
            sclContext.put((Object)"graph", oldGraph);
        }
    }

    @Override
    public void setValue(WriteGraph graph, Variable context, Object value) throws DatabaseException {
        SCLContext sclContext = SCLContext.getCurrent();
        Object oldGraph = sclContext.put((Object)"graph", (Object)graph);
        try {
            try {
                this.setValue2.apply((Object)context, value);
            }
            catch (Throwable t) {
                throw new NonWritableVariableException("Could not write value " + String.valueOf(value) + " for " + String.valueOf(context.getRepresents((ReadGraph)graph)), t);
            }
        }
        finally {
            sclContext.put((Object)"graph", oldGraph);
        }
    }

    @Override
    public void setValue(WriteGraph graph, Variable context, Object value, Binding binding) throws DatabaseException {
        SCLContext sclContext = SCLContext.getCurrent();
        Object oldGraph = sclContext.put((Object)"graph", (Object)graph);
        try {
            try {
                this.setValue3.apply((Object)context, value, (Object)binding);
            }
            catch (Throwable t) {
                throw new NonWritableVariableException("Could not write value " + String.valueOf(value) + " for " + String.valueOf(context.getRepresents((ReadGraph)graph)) + " with binding " + binding, t);
            }
        }
        finally {
            sclContext.put((Object)"graph", oldGraph);
        }
    }

    @Override
    public Datatype getDatatype(ReadGraph graph, Variable context) throws DatabaseException {
        SCLContext sclContext = SCLContext.getCurrent();
        Object oldGraph = sclContext.put((Object)"graph", (Object)graph);
        try {
            Datatype datatype = (Datatype)this.getDatatype.apply((Object)context);
            return datatype;
        }
        catch (Throwable t) {
            throw new DatatypeNotFoundException("Could not find datatype for " + String.valueOf(context.getRepresents(graph)), t);
        }
        finally {
            sclContext.put((Object)"graph", oldGraph);
        }
    }
}

