/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.variable;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.function.All;
import org.simantics.db.layer0.variable.AbstractPropertyVariable;
import org.simantics.db.layer0.variable.ConstantPropertyVariableBuilder;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.utils.ObjectUtils;

public class ConstantPropertyVariable
extends AbstractPropertyVariable {
    protected final Variable parent;
    final String name;
    final Object value;
    final Binding binding;
    final Map<String, Variable> properties;
    private final Resource predicate;

    public ConstantPropertyVariable(Variable parent, String name, Object value, Binding binding, Resource predicate, Collection<ConstantPropertyVariableBuilder> propertyBuilders, Set<String> classifications) {
        assert (parent != null);
        assert (name != null);
        this.parent = parent;
        this.name = name;
        this.value = value;
        this.binding = binding;
        this.predicate = predicate;
        this.properties = new HashMap<String, Variable>(propertyBuilders.size());
        for (ConstantPropertyVariableBuilder builder : propertyBuilders) {
            this.properties.put(builder.getName(), builder.build(this));
        }
        if (!classifications.isEmpty()) {
            this.properties.put("classifications", new ConstantPropertyVariable(this, "classifications", classifications, null));
        }
    }

    public ConstantPropertyVariable(Variable parent, String name, Object value, Binding binding, Collection<ConstantPropertyVariableBuilder> propertyBuilders, Set<String> classifications) {
        this(parent, name, value, binding, null, Collections.emptyList(), Collections.emptySet());
    }

    public ConstantPropertyVariable(Variable parent, String name, Object value, Binding binding) {
        this(parent, name, value, binding, Collections.emptyList(), Collections.emptySet());
    }

    @Override
    public <T> T getValue(ReadGraph graph) throws DatabaseException {
        return (T)this.value;
    }

    @Override
    public <T> T getValue(ReadGraph graph, Binding binding) throws DatabaseException {
        return (T)this.value;
    }

    @Override
    public void setValue(WriteGraph graph, Object value, Binding binding) throws DatabaseException {
        throw new DatabaseException("Value is constant.");
    }

    @Override
    public String getName(ReadGraph graph) throws DatabaseException {
        return this.name;
    }

    @Override
    public Resource getType(ReadGraph graph) throws DatabaseException {
        return null;
    }

    @Override
    public Resource getPossibleType(ReadGraph graph) throws DatabaseException {
        return null;
    }

    @Override
    public Resource getType(ReadGraph graph, Resource baseType) throws DatabaseException {
        return null;
    }

    @Override
    public Resource getPossibleType(ReadGraph graph, Resource baseType) throws DatabaseException {
        return null;
    }

    @Override
    public Variable getParent(ReadGraph graph) throws DatabaseException {
        return this.parent;
    }

    @Override
    public Resource getRepresents(ReadGraph graph) throws DatabaseException {
        return null;
    }

    @Override
    public Datatype getDatatype(ReadGraph graph) throws DatabaseException {
        return this.binding != null ? this.binding.type() : null;
    }

    @Override
    public Resource getPropertyResource(ReadGraph graph) throws DatabaseException {
        return this.predicate;
    }

    @Override
    public Resource getContainerResource(ReadGraph graph) throws DatabaseException {
        return null;
    }

    @Override
    public Variable getPredicate(ReadGraph graph) throws DatabaseException {
        return null;
    }

    @Override
    protected Variable getPossibleDomainProperty(ReadGraph graph, String name) throws DatabaseException {
        Variable result = this.properties.get(name);
        if (result != null) {
            return result;
        }
        if (this.predicate != null) {
            HashMap<String, Variable> ps = new HashMap<String, Variable>();
            All.collectPropertiesFromContext(graph, this, this.predicate, ps);
            return ps.get(name);
        }
        return null;
    }

    @Override
    public Map<String, Variable> collectDomainProperties(ReadGraph graph, Map<String, Variable> properties) throws DatabaseException {
        if (!this.properties.isEmpty()) {
            if (properties == null) {
                properties = new HashMap<String, Variable>(this.properties.size());
            }
            properties.putAll(this.properties);
        }
        if (this.predicate != null) {
            All.collectPropertiesFromContext(graph, this, this.predicate, properties);
        }
        return properties;
    }

    @Override
    public Set<String> getClassifications(ReadGraph graph) throws DatabaseException {
        Variable property = this.getPossibleDomainProperty(graph, "classifications");
        if (property != null) {
            return (Set)property.getValue(graph);
        }
        return Collections.emptySet();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.parent.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.binding == null ? 0 : this.binding.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConstantPropertyVariable other = (ConstantPropertyVariable)obj;
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (!this.parent.equals(other.parent)) {
            return false;
        }
        if (!ObjectUtils.objectEquals((Object)this.value, (Object)other.value)) {
            return false;
        }
        return ObjectUtils.objectEquals((Object)this.binding, (Object)other.binding);
    }
}

