/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Remover;
import org.simantics.db.layer0.adapter.impl.EntityRemover;
import org.simantics.db.layer0.exception.CannotRemoveException;
import org.simantics.db.layer0.internal.SimanticsInternal;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.db.request.WriteResult;
import org.simantics.utils.strings.EString;

public final class RemoverUtil {
    public static boolean canRemove(ReadGraph graph, Resource resource) throws DatabaseException {
        String problem;
        Remover remover = RemoverUtil.getPossibleRemover(graph, resource);
        return remover == null || (problem = remover.canRemove(graph, new HashMap<Object, Object>(4))) == null;
    }

    public static void remove(WriteGraph graph, Resource resource) throws DatabaseException {
        if (!RemoverUtil.tryRemover(graph, resource)) {
            EntityRemover.remove(graph, resource, true);
        }
    }

    public static boolean tryRemover(WriteGraph graph, Resource resource) throws DatabaseException {
        Remover remover = RemoverUtil.getPossibleRemover((ReadGraph)graph, resource);
        if (remover != null) {
            remover.remove(graph);
            return true;
        }
        return false;
    }

    public static Remover getPossibleRemover(ReadGraph graph, Resource resource) throws DatabaseException {
        return (Remover)graph.getPossibleAdapter(resource, Remover.class);
    }

    public static String testRemoval(final Collection<Resource> rs) throws DatabaseException {
        return (String)SimanticsInternal.getSession().syncRequest((Read)new UniqueRead<String>(){

            public String perform(ReadGraph graph) throws DatabaseException {
                return RemoverUtil.testRemoval(graph, rs, null);
            }
        });
    }

    public static String testRemoval(ReadGraph graph, Collection<Resource> rs, List<Remover> removers) throws DatabaseException {
        if (removers == null) {
            removers = new ArrayList<Remover>(rs.size());
        }
        for (Resource r : rs) {
            Remover remover = (Remover)graph.getPossibleAdapter(r, Remover.class);
            if (remover == null) continue;
            removers.add(remover);
        }
        HashMap<Object, Object> aux = new HashMap<Object, Object>();
        ArrayList<String> errors = new ArrayList<String>(2);
        for (Remover remover : removers) {
            String error = remover.canRemove(graph, aux);
            if (error == null) continue;
            errors.add(error);
        }
        if (!errors.isEmpty()) {
            return EString.implode(errors);
        }
        return null;
    }

    public static String testRemoval(ReadGraph graph, Collection<Resource> rs) throws DatabaseException {
        return RemoverUtil.testRemoval(graph, rs, null);
    }

    public static String checkedRemoval(final Collection<Resource> rs) throws DatabaseException {
        String problems = RemoverUtil.testRemoval(rs);
        if (problems != null) {
            return problems;
        }
        SimanticsInternal.getSession().syncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
                for (Resource r : rs) {
                    graph.addMetadata((Metadata)cm.add("Removing " + r + "."));
                }
                ArrayList<Remover> removers = new ArrayList<Remover>(rs.size());
                String error = RemoverUtil.testRemoval((ReadGraph)graph, rs, removers);
                if (error != null) {
                    throw new CannotRemoveException(error);
                }
                for (Remover remover : removers) {
                    remover.remove(graph);
                }
            }
        });
        return null;
    }

    public static boolean tryCollectionRemover(final Collection<Resource> rs) throws DatabaseException {
        return (Boolean)SimanticsInternal.getSession().syncRequest((WriteResult)new WriteResultRequest<Boolean>(){

            public Boolean perform(WriteGraph graph) throws DatabaseException {
                graph.markUndoPoint();
                ArrayList<Remover> removers = new ArrayList<Remover>();
                HashMap<Remover, String> removedResources = new HashMap<Remover, String>();
                for (Resource r : rs) {
                    Remover remover = (Remover)graph.getPossibleAdapter(r, Remover.class);
                    if (remover == null) continue;
                    removers.add(remover);
                    removedResources.put(remover, NameUtils.getSafeName((ReadGraph)graph, (Resource)r, (boolean)true));
                }
                HashMap<Object, Object> aux = new HashMap<Object, Object>();
                ArrayList<String> errors = new ArrayList<String>(removers.size());
                for (Remover remover : removers) {
                    String error = remover.canRemove((ReadGraph)graph, aux);
                    if (error == null) continue;
                    errors.add(error);
                }
                if (!errors.isEmpty()) {
                    throw new CannotRemoveException(EString.implode(errors));
                }
                CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
                for (Remover remover : removers) {
                    remover.remove(graph);
                    graph.addMetadata((Metadata)cm.add("Removed " + (String)removedResources.get(remover) + "."));
                }
                return true;
            }
        });
    }
}

