/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.genericrelation;

import java.util.Collection;
import org.simantics.datatypes.literal.GUID;
import org.simantics.db.Resource;

public class IndexQueries {
    private static final String[] RESERVED_WORDS = new String[]{"AND", "\\AND", "OR", "\\OR", "NOT", "\\NOT"};

    public static String escape(String s, boolean escapeWildcards) {
        return IndexQueries.escape(s, escapeWildcards, true);
    }

    public static String escape(String s, boolean escapeWildcards, boolean escapeKeywords) {
        if (!IndexQueries.needsEscaping(s, escapeWildcards, escapeKeywords)) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length() + 8);
        int len = s.length();
        boolean lastWhitespace = true;
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (c == '\\' || c == '+' || c == '-' || c == '!' || c == '(' || c == ')' || c == ':' || c == '^' || c == '[' || c == ']' || c == '\"' || c == '{' || c == '}' || c == '~' || c == '|' || c == '&' || c == '/' || c == ' ' || escapeWildcards && (c == '*' || c == '?')) {
                sb.append('\\');
                sb.append(c);
                lastWhitespace = false;
            } else if (Character.isWhitespace(c)) {
                sb.append(c);
                lastWhitespace = true;
            } else {
                int reslen;
                if (escapeKeywords && lastWhitespace && (reslen = IndexQueries.processReservedWords(s, i, sb)) > 0) {
                    i += reslen;
                    lastWhitespace = false;
                    continue;
                }
                sb.append(c);
                lastWhitespace = false;
            }
            ++i;
        }
        return sb.toString();
    }

    private static boolean needsEscaping(String s, boolean escapeWildcards, boolean escapeKeywords) {
        int len = s.length();
        boolean lastWhitespace = true;
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (c == '\\' || c == '+' || c == '-' || c == '!' || c == '(' || c == ')' || c == ':' || c == '^' || c == '[' || c == ']' || c == '\"' || c == '{' || c == '}' || c == '~' || c == '|' || c == '&' || c == '/' || c == ' ' || escapeWildcards && (c == '*' || c == '?')) {
                return true;
            }
            if (Character.isWhitespace(c)) {
                lastWhitespace = true;
            } else {
                int reslen;
                if (escapeKeywords && lastWhitespace && (reslen = IndexQueries.processReservedWords(s, i, null)) > 0) {
                    return true;
                }
                lastWhitespace = false;
            }
            ++i;
        }
        return false;
    }

    private static int processReservedWords(String s, int fromIndex, StringBuilder sb) {
        int total = RESERVED_WORDS.length;
        int w = 0;
        while (w < total) {
            String word = RESERVED_WORDS[w];
            int len = word.length();
            if (s.regionMatches(false, fromIndex, word, 0, len)) {
                if (sb != null) {
                    String replacement = RESERVED_WORDS[w + 1];
                    sb.append(replacement);
                }
                return len;
            }
            w += 2;
        }
        return 0;
    }

    public static String escape(String s) {
        return IndexQueries.escape(s, false);
    }

    public static StringBuilder escapeTerm(String field, String term, boolean escapeWildcards, StringBuilder result) {
        if (field != null) {
            result.append(field).append(':');
        }
        result.append(IndexQueries.escape(term, escapeWildcards));
        return result;
    }

    public static String escapeTerm(String field, String term, boolean escapeWildcards) {
        return IndexQueries.escapeTerm(field, term, escapeWildcards, new StringBuilder()).toString();
    }

    public static StringBuilder quoteTerm(String field, String term, StringBuilder result) {
        if (field != null) {
            result.append(field).append(':');
        }
        result.append("\"");
        result.append(term.replaceAll("(\"|\\\\)", "\\\\$0"));
        result.append("\"");
        return result;
    }

    public static String quoteTerm(String term) {
        return IndexQueries.quoteTerm(null, term, new StringBuilder(term.length() * 2)).toString();
    }

    public static String quoteTerm(String field, String term) {
        return IndexQueries.quoteTerm(field, term, new StringBuilder(term.length() * 2 + (field != null ? field.length() + 1 : 0))).toString();
    }

    public static StringBuilder appendLongTerm(StringBuilder sb, String field, long term) {
        return sb.append(field).append(':').append(term);
    }

    public static String longTerm(String field, long term) {
        return IndexQueries.appendLongTerm(new StringBuilder(), field, term).toString();
    }

    public static StringBuilder appendResourceIdTerm(StringBuilder sb, String field, Resource term) {
        return IndexQueries.appendLongTerm(sb, field, term.getResourceId());
    }

    public static String resourceIdTerm(String field, Resource term) {
        return IndexQueries.appendLongTerm(new StringBuilder(), field, term.getResourceId()).toString();
    }

    private static String join(String withString, String ... exps) {
        if (exps.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(128);
        int i = 0;
        while (i < exps.length - 1) {
            sb.append(exps[i]).append(withString);
            ++i;
        }
        sb.append(exps[exps.length - 1]);
        return sb.toString();
    }

    public static String and(String exp1, String exp2) {
        return String.valueOf(exp1) + " AND " + exp2;
    }

    public static String and(String ... exps) {
        return IndexQueries.join(" AND ", exps);
    }

    public static String or(String exp1, String exp2) {
        return String.valueOf(exp1) + " OR " + exp2;
    }

    public static String or(String ... exps) {
        return IndexQueries.join(" OR ", exps);
    }

    public static String idFromGUID(GUID guid) {
        return guid != null ? guid.indexString() : "";
    }

    public static String toResourceIdString(Resource r, Collection<Resource> rs) {
        StringBuilder sb = new StringBuilder();
        sb.append(r.getResourceId());
        for (Resource rr : rs) {
            sb.append(' ').append(rr.getResourceId());
        }
        return sb.toString();
    }

    public static String toResourceIdString(Collection<Resource> rs) {
        if (rs.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Resource rr : rs) {
            if (!first) {
                sb.append(' ');
            }
            first = false;
            sb.append(rr.getResourceId());
        }
        return sb.toString();
    }
}

