/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.adapter.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.util.URIStringUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.service.XSupport;
import org.simantics.graph.db.AbstractImportAdvisor2;
import org.simantics.graph.db.IImportAdvisor2;
import org.simantics.graph.db.MissingDependencyException;
import org.simantics.graph.db.TransferableGraphImporter;
import org.simantics.graph.representation.Root;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.datastructures.Triple;

public class SharedOntologyImportAdvisor
extends AbstractImportAdvisor2 {
    private Layer0 L0;
    private Map<Root, Triple<Resource, Resource, List<String>>> toCreate = new HashMap<Root, Triple<Resource, Resource, List<String>>>();
    private Map<Root, Resource> created = new HashMap<Root, Resource>();
    private final boolean published;
    private final Map<String, Object> context;

    public SharedOntologyImportAdvisor(boolean published) {
        this(Collections.emptyMap(), published);
    }

    public SharedOntologyImportAdvisor(Map<String, Object> context, boolean published) {
        this.context = context;
        this.published = published;
    }

    private Resource getNames(ReadGraph graph, String uri, List<String> names) throws DatabaseException {
        if ("http://".equals(uri) || "http:/".equals(uri)) {
            return graph.getRootLibrary();
        }
        String[] parts = URIStringUtils.splitURI((String)uri);
        if (parts != null && parts.length == 2) {
            Resource base = graph.getPossibleResource(parts[0]);
            if (base == null) {
                base = this.getNames(graph, parts[0], names);
            }
            names.add(parts[1]);
            return base;
        }
        return null;
    }

    public Resource analyzeRoot(ReadGraph graph, Root r) throws DatabaseException {
        Resource existing;
        String renamed;
        this.L0 = Layer0.getInstance((ReadGraph)graph);
        String uri = r.name;
        Map renameMap = (Map)this.context.get("renameMap");
        if (renameMap != null && (renamed = (String)renameMap.get(uri)) != null) {
            uri = renamed;
        }
        if ((existing = graph.getPossibleResource(uri)) != null) {
            if (graph.isInstanceOf(existing, this.L0.ExternalEntity)) {
                this.created.put(r, existing);
                this.addRootInfo(r, r.name, existing);
                return null;
            }
            throw new DatabaseException("Shared library " + uri + " exists already.");
        }
        Resource type = graph.getPossibleResource(r.type);
        if (type == null) {
            HashSet<String> types = new HashSet<String>();
            types.add(r.type);
            throw new MissingDependencyException(types);
        }
        ArrayList<String> namesToCreate = new ArrayList<String>();
        Resource base = this.getNames(graph, uri, namesToCreate);
        this.toCreate.put(r, (Triple<Resource, Resource, List<String>>)Triple.make((Object)base, (Object)type, namesToCreate));
        return null;
    }

    public Resource getTarget() {
        return null;
    }

    public Resource createRoot(WriteOnlyGraph graph, Root r) throws DatabaseException {
        return this.createRoot(graph, r, null);
    }

    public Resource createRoot(WriteOnlyGraph graph, Root root, Resource resource) throws DatabaseException {
        return this.created.get(root);
    }

    public void beforeWrite(WriteOnlyGraph graph, TransferableGraphImporter process) throws DatabaseException {
        XSupport xs = (XSupport)graph.getService(XSupport.class);
        Pair mode = xs.getServiceMode();
        try {
            graph.markUndoPoint();
            if (this.published) {
                xs.setServiceMode(true, true);
            } else {
                xs.setServiceMode(true, ((Boolean)mode.second).booleanValue());
            }
            graph.setClusterSet4NewResource(graph.getRootLibrary());
            graph.flushCluster();
            for (IImportAdvisor2.RootInfo rootInfo : this.getRootInfo()) {
                graph.deny(rootInfo.resource, this.L0.InstanceOf, null, this.L0.ExternalEntity, null);
            }
            for (Map.Entry entry : this.toCreate.entrySet()) {
                Triple recipe = (Triple)entry.getValue();
                Resource base = (Resource)recipe.first;
                int i = 0;
                while (i < ((List)recipe.third).size() - 1) {
                    Resource lib = graph.newResource();
                    graph.claim(lib, this.L0.InstanceOf, null, this.L0.Library);
                    graph.addLiteral(lib, this.L0.HasName, this.L0.NameOf, (Object)URIStringUtils.unescape((String)((String)((List)recipe.third).get(i))), (Binding)Bindings.STRING);
                    graph.claim(base, this.L0.ConsistsOf, this.L0.PartOf, lib);
                    base = lib;
                    ++i;
                }
                Resource lib = graph.newResource();
                graph.newClusterSet(lib);
                graph.setClusterSet4NewResource(lib);
                graph.claim(lib, this.L0.InstanceOf, null, (Resource)recipe.second);
                String name = URIStringUtils.unescape((String)((String)((List)recipe.third).get(((List)recipe.third).size() - 1)));
                graph.addLiteral(lib, this.L0.HasName, this.L0.NameOf, (Object)name, (Binding)Bindings.STRING);
                graph.claim(base, this.L0.ConsistsOf, this.L0.PartOf, lib);
                this.addRootInfo((Root)entry.getKey(), name, lib);
                this.created.put((Root)entry.getKey(), lib);
            }
            graph.flushCluster();
        }
        finally {
            xs.setServiceMode(((Boolean)mode.first).booleanValue(), ((Boolean)mode.second).booleanValue());
        }
    }

    public void afterWrite(WriteOnlyGraph graph, TransferableGraphImporter process) throws DatabaseException {
        String name = ((IImportAdvisor2.RootInfo)this.getRootInfo().iterator().next()).name;
        Resource resource = ((IImportAdvisor2.RootInfo)this.getRootInfo().iterator().next()).resource;
        Layer0Utils.addCommentMetadata(graph, "Imported Shared Ontology " + name + " " + resource);
        if (this.published) {
            XSupport xs = (XSupport)graph.getService(XSupport.class);
            xs.setServiceMode(false, false);
        }
        graph.setClusterSet4NewResource(graph.getRootLibrary());
        graph.flushCluster();
    }

    public boolean allowImmutableModifications() {
        return false;
    }

    public Resource createChild(WriteOnlyGraph graph, TransferableGraphImporter process, Resource parent, String name) throws DatabaseException {
        return process.createChild(graph, parent, null, name);
    }

    public Resource createChild(WriteOnlyGraph graph, TransferableGraphImporter process, Resource parent, Resource child, String name) throws DatabaseException {
        return process.createChild(graph, parent, child, name);
    }
}

