package org.simantics.db.layer0.request;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.simulation.ontology.SimulationResource;

public class PossibleExperiment extends ResourceRead<Resource> {

    public PossibleExperiment(Resource partOfExperiment) {
        super(partOfExperiment);
    }

    @Override
    public Resource perform(ReadGraph graph) throws DatabaseException {


    	SimulationResource SIMU = SimulationResource.getInstance(graph);
    	Layer0 L0 = Layer0.getInstance(graph);
    	
        if (graph.isInstanceOf(resource, SIMU.Experiment))
            return resource;
        
        Resource parent = graph.getPossibleObject(resource, L0.PartOf);
        if (parent == null)
            return null;
        
        else return graph.syncRequest(new PossibleExperiment(parent));

    }

}
