/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.request;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceMultiRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ResourceNotFoundException;
import org.simantics.db.procedure.SyncMultiProcedure;
import org.simantics.layer0.Layer0;
import org.simantics.project.ontology.ProjectResource;

/**
 * @author Antti Villberg
 */
public class OntologiesForModel extends ResourceMultiRead<Resource> {

    public OntologiesForModel(Resource model) {
        super(model);
    }

    public void check(ReadGraph graph, Resource resource, SyncMultiProcedure<Resource> callback) throws DatabaseException {

        Layer0 L0 = Layer0.getInstance(graph);
        ProjectResource PROJ = ProjectResource.getInstance(graph);

        for (Resource r : graph.getObjects(resource, PROJ.RequiresNamespace)) {
            if (graph.isInstanceOf(r, L0.URI)) {
                String uri = graph.getValue(r);
                try {
                    Resource ns = graph.getResource(uri);
                    if (graph.isInstanceOf(ns, L0.Ontology)) {
                        callback.execute(graph, ns);
                    }
                } catch (ResourceNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }

    }

    @Override
    public void perform(ReadGraph graph, SyncMultiProcedure<Resource> callback) throws DatabaseException {

        Layer0 L0 = Layer0.getInstance(graph);

        Resource project = graph.getSingleObject(resource, L0.PartOf);

        for (Resource feature : graph.syncRequest(new NamespaceRequirements(project))) {
            check(graph, feature, callback);
        }

        callback.finished(graph);

    }

}
