/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.indexing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.Term;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.indexing.DatabaseIndexing;
import org.simantics.db.indexing.IndexedRelationsSearcher;
import org.simantics.db.indexing.MemoryIndexing;
import org.simantics.db.indexing.QueryIndex;
import org.simantics.db.indexing.QueryIndexResources;
import org.simantics.db.indexing.exception.IndexCorruptedException;
import org.simantics.db.layer0.genericrelation.IndexQueries;
import org.simantics.db.layer0.genericrelation.IndexedRelations;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.db.service.CollectionSupport;
import org.simantics.layer0.Layer0;
import org.simantics.operation.Layer0X;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexUtils.class);

    public static Collection<Map<String, Object>> find(ReadGraph graph, Resource index, String filter) throws DatabaseException {
        ArrayList<Map<String, Object>> indexResult = (ArrayList<Map<String, Object>>)graph.syncRequest((Read)new QueryIndex(index, filter), (Listener)TransientCacheListener.instance());
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Collection linkedRoots = (Collection)graph.syncRequest((Read)new ObjectsWithType(index, L0.IsLinkedTo, L0.IndexRoot));
        if (linkedRoots.isEmpty()) {
            return indexResult;
        }
        ArrayList<Map<String, Object>> result = indexResult;
        for (Resource dep : linkedRoots) {
            Collection<Map<String, Object>> linkedIndexResults = IndexUtils.find(graph, dep, filter);
            if (linkedIndexResults.isEmpty()) continue;
            if (result == indexResult) {
                result = new ArrayList<Map<String, Object>>(indexResult.size() + linkedIndexResults.size());
                result.addAll(indexResult);
            }
            result.addAll(linkedIndexResults);
        }
        return result;
    }

    public static List<Resource> findResources(ReadGraph graph, Resource index, String filter) throws DatabaseException {
        List indexResult = (List)graph.syncRequest((Read)new QueryIndexResources(index, filter), (Listener)TransientCacheListener.instance());
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        CollectionSupport coll = (CollectionSupport)graph.getService(CollectionSupport.class);
        Collection linkedRoots = (Collection)graph.syncRequest((Read)new ObjectsWithType(index, L0.IsLinkedTo, L0.IndexRoot));
        if (linkedRoots.isEmpty()) {
            return indexResult;
        }
        List result = indexResult;
        for (Resource dep : linkedRoots) {
            List<Resource> linkedIndexResults = IndexUtils.findResources(graph, dep, filter);
            if (linkedIndexResults.isEmpty()) continue;
            if (result == indexResult) {
                result = coll.createList();
                result.addAll(indexResult);
            }
            result.addAll(linkedIndexResults);
        }
        Layer0Utils.sort((ReadGraph)graph, (List)result);
        return result;
    }

    public static Collection<Resource> findByName(ReadGraph graph, Resource model, String name) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        HashSet<Resource> results = new HashSet<Resource>();
        String search = IndexQueries.quoteTerm((String)"Name", (String)name);
        for (Resource resource : IndexUtils.findResources(graph, model, search)) {
            if (!name.equals(graph.getPossibleRelatedValue(resource, L0.HasName, (Binding)Bindings.STRING))) continue;
            results.add(resource);
        }
        return results;
    }

    public static Collection<Resource> findByType(ReadGraph graph, Resource model, Resource type) throws DatabaseException {
        HashSet<Resource> results = new HashSet<Resource>();
        String search = IndexQueries.resourceIdTerm((String)"TypeId", (Resource)type);
        for (Resource resource : IndexUtils.findResources(graph, model, search)) {
            if (!graph.isInstanceOf(resource, type)) continue;
            results.add(resource);
        }
        return results;
    }

    public static Collection<Resource> findByTypeAndName(ReadGraph graph, Resource model, Resource type, String name) throws DatabaseException {
        HashSet<Resource> results = new HashSet<Resource>();
        String search = IndexQueries.and((String)IndexQueries.resourceIdTerm((String)"TypeId", (Resource)type), (String)IndexQueries.quoteTerm((String)"Name", (String)name));
        for (Resource resource : IndexUtils.findResources(graph, model, search)) {
            if (!graph.isInstanceOf(resource, type)) continue;
            results.add(resource);
        }
        return results;
    }

    public static void flushIndexCaches(IProgressMonitor progress, Session session) throws Exception {
        MemoryIndexing mem = MemoryIndexing.getInstance(session);
        mem.flush(progress);
    }

    public static List<Object> list(IProgressMonitor progress, Session session, Resource indexRoot) throws Exception {
        List<Object> results;
        if (progress == null) {
            progress = new NullProgressMonitor();
        }
        MemoryIndexing mem = MemoryIndexing.getInstance(session);
        Layer0X L0X = Layer0X.getInstance((RequestProcessor)session);
        mem.flush(progress);
        IndexedRelationsSearcher searcher = mem.get((RequestProcessor)session, L0X.DependenciesRelation, indexRoot);
        try {
            results = searcher.doList(progress, (RequestProcessor)session);
        }
        catch (IndexCorruptedException e) {
            LOGGER.error("Index is corrupted for indexRoot {}", (Object)indexRoot, (Object)e);
            IndexUtils.rebuild(session, progress);
            searcher = mem.get((RequestProcessor)session, L0X.DependenciesRelation, indexRoot);
            results = searcher.doList(progress, (RequestProcessor)session);
        }
        return results;
    }

    private static void rebuild(Session session, IProgressMonitor monitor) throws Exception {
        LOGGER.error("Trying to rebuild index");
        DatabaseIndexing.deleteAllIndexes();
        ((IndexedRelations)session.getService(IndexedRelations.class)).fullRebuild((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)100), (RequestProcessor)session);
    }

    public static Term longTerm(String key, Long value) {
        BytesRef ref = new BytesRef();
        NumericUtils.longToPrefixCoded((long)value, (int)0, (BytesRef)ref);
        return new Term(key, ref);
    }
}

