/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import org.simantics.db.impl.query.CacheEntryBase;
import org.simantics.db.impl.query.Query;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.QuerySerializer;

public abstract class BinaryQuery<Procedure>
extends CacheEntryBase<Procedure>
implements Query {
    public final long id;

    public BinaryQuery(long r1, long r2) {
        assert (r1 != 0L);
        assert (r2 != 0L);
        this.id = BinaryQuery.id(r1, r2);
        assert (this.id != 0L);
    }

    @Override
    int makeHash() {
        return this.r1() ^ this.r2();
    }

    public final int r1() {
        return (int)(this.id >>> 32);
    }

    public final int r2() {
        return (int)this.id;
    }

    protected static final long id(long r1, long r2) {
        long result = r1 << 32 | r2 & 0xFFFFFFFFL;
        return result;
    }

    @Override
    public int type() {
        return 0;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BinaryQuery other = (BinaryQuery)object;
        return this.id == other.id;
    }

    @Override
    public final Query getQuery() {
        return this;
    }

    @Override
    public abstract void removeEntry(QueryProcessor var1);

    @Override
    public long cluster(QueryProcessor processor) {
        return processor.cluster(this.r1());
    }

    @Override
    public void serializeKey(QuerySerializer serializer) {
        serializer.addResource(this.r1());
        serializer.addResource(this.r2());
    }
}

