/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl;

import java.util.UUID;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.ClusterI;
import org.simantics.db.impl.ClusterSupport;
import org.simantics.db.impl.IClusterTable;
import org.simantics.db.impl.Table;
import org.simantics.db.impl.TableSizeListener;
import org.simantics.db.service.ClusterUID;
import org.simantics.db.service.ClusteringSupport;

public abstract class ClusterBase
implements ClusterI,
TableSizeListener {
    protected static boolean DEBUG = false;
    protected static boolean VERBOSE = false;
    public final ClusterUID clusterUID;
    public final long clusterId;
    public final int clusterKey;
    protected long importance;

    protected ClusterBase() {
        this.clusterUID = null;
        this.clusterId = 0L;
        this.clusterKey = 0;
    }

    public ClusterBase(ClusterSupport support, ClusterUID clusterUID, int clusterKey) {
        this.clusterUID = clusterUID;
        this.clusterId = support.getClusterIdOrCreate(clusterUID);
        int n = this.clusterKey = clusterKey != 0 ? clusterKey : support.createClusterKeyByClusterUID(this.clusterUID, this.clusterId);
        if (DEBUG) {
            System.out.println("DEBUG: Created cluster " + clusterUID + " id=" + this.clusterId + " key=" + clusterKey);
            if (VERBOSE) {
                new Exception().printStackTrace();
            }
        }
    }

    @Override
    public final int getClusterKey() {
        return this.clusterKey;
    }

    @Override
    public final long getClusterId() {
        return this.clusterId;
    }

    @Override
    public final long getImportance() {
        return this.importance;
    }

    @Override
    public final void setImportance(long importance) {
        this.importance = importance;
    }

    @Override
    public ClusterUID getClusterUID() {
        return this.clusterUID;
    }

    public abstract ClusterBase toBig(ClusterSupport var1) throws DatabaseException;

    public abstract void checkDirectReference(int var1) throws DatabaseException;

    public abstract void checkForeingIndex(int var1) throws DatabaseException;

    public abstract void checkObjectSetReference(int var1) throws DatabaseException;

    public abstract void checkValueInit() throws DatabaseException;

    public abstract void checkCompleteSetReference(int var1) throws DatabaseException;

    public abstract void checkPredicateIndex(int var1) throws DatabaseException;

    public abstract void checkValue(int var1, int var2) throws DatabaseException;

    public abstract void checkValueFini() throws DatabaseException;

    public abstract Table<?> getPredicateTable();

    public abstract Table<?> getForeignTable();

    public abstract Table<?> getCompleteTable();

    public abstract Table<?> getValueTable();

    public abstract Table<?> getObjectTable();

    public abstract int execute(int var1) throws DatabaseException;

    public abstract int makeResourceKey(int var1) throws DatabaseException;

    public abstract IClusterTable getClusterTable();

    public static class IdImpl
    implements ClusteringSupport.Id {
        private UUID id;

        public IdImpl(UUID id) {
            this.id = id;
        }

        public String toString() {
            long[] longs = this.toLong();
            return String.format("%x.%x", longs[0], longs[1]);
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (this == o) {
                return true;
            }
            if (o instanceof IdImpl) {
                return this.id.equals(((IdImpl)o).id);
            }
            if (o instanceof ClusteringSupport.Id) {
                long[] other;
                long[] self = this.toLong();
                if (self[0] != (other = ((ClusteringSupport.Id)o).toLong())[0]) {
                    return false;
                }
                return self[1] == other[1];
            }
            return false;
        }

        public long[] toLong() {
            long[] longs = new long[]{this.id.getMostSignificantBits(), this.id.getLeastSignificantBits()};
            return longs;
        }
    }
}

