package org.simantics.db.impl.query;

import org.simantics.db.exception.DatabaseException;

public class ValueQueryFactory extends QueryFactoryBase {

    @Override
    public CacheEntryBase readKeyAndValue(QueryDeserializer deserializer) throws DatabaseException {
        ValueQuery result = reference(deserializer);
        byte[] bytes = deserializer.readByteArray();
        result.setResult(bytes);
        result.setReady();
        return result;
    }
    
    @Override
    public <T extends CacheEntryBase> T reference(QueryDeserializer deserializer) throws DatabaseException {
        return (T)deserializer.readValueQuery();
    }

}
