/*******************************************************************************
 * Copyright (c) 2018 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.db.impl.query;

import org.simantics.db.common.exception.DebugException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.procedure.InternalProcedure;

public abstract class UnaryQueryP<R> extends UnaryQuery<InternalProcedure<R>> implements InternalProcedure<R> {

    public UnaryQueryP(int r) {
        super(r);
    }

    public abstract void compute(ReadGraphImpl graph, InternalProcedure<R> procedure) throws DatabaseException;

    @Override
    public final void recompute(ReadGraphImpl graph) throws DatabaseException {

        compute(graph, new InternalProcedure<R>() {

            @Override
            public void execute(ReadGraphImpl graph, R result) {
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                if (DebugException.DEBUG)
                    new DebugException(t).printStackTrace();
                throw new Error("Error in recompute.", t);
            }

        });

    }

    @Override
    public final Object performFromCache(ReadGraphImpl graph, InternalProcedure<R> procedure)
            throws DatabaseException {

        if (handleException(graph, procedure))
            return (Throwable) statusOrException;

        procedure.execute(graph, (R)getResult());

        return result;

    }

    @Override
    public final void execute(ReadGraphImpl graph, R result) throws DatabaseException {
        setResult(result);
        setReady();
    }

    @Override
    public final void exception(ReadGraphImpl graph, Throwable throwable) throws DatabaseException {
        except(throwable);
    }

    @Override
    final boolean isImmutable(ReadGraphImpl graph) {
        return graph.processor.isImmutable(id);
    }

}
