/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.impl.query;

import java.lang.reflect.Array;
import java.util.ArrayList;



/**
 * An implementation of the Map interface which uses an open addressed
 * hash table to store its contents.
 *
 * Created: Sun Nov  4 08:52:45 2001
 *
 * @author Eric D. Friedman
 * @version $Id: BinaryQueryHashMap.java,v 1.2 2008/03/14 11:38:53 tuoksk Exp $
 */
public class UnaryQueryHashMap<Procedure> extends UnaryQueryHash<Procedure> {

    /**
     * Creates a new <code>THashMap</code> instance with the default
     * capacity and load factor.
     */
    public UnaryQueryHashMap() {
        super();
    }

    /**
     * initialize the value array of the map.
     *
     * @param initialCapacity an <code>int</code> value
     * @return an <code>int</code> value
     */
    protected int setUp(int initialCapacity) {
        int capacity;
        
        capacity = super.setUp(initialCapacity);
//        _values = (Object[]) new Object[capacity];
        return capacity;
    }
    
    /**
     * Inserts a key/value pair into the map.
     *
     * @param key an <code>Object</code> value
     * @param value an <code>Object</code> value
     * @return the previous value associated with <tt>key</tt>,
     * or null if none was found.
     */
    @SuppressWarnings("unchecked")
	public UnaryQuery put(final int id, final UnaryQuery value) {
        UnaryQuery previous = null;
        Object oldKey;
        int index = insertionIndex(id);
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index -1;
            previous = _set[index];
            isNewMapping = false;
        }
        oldKey = _set[index];
        _set[index] = value;
        if (isNewMapping) {
            postInsertHook(oldKey == null);
        }

        return previous;
    }

    /**
     * rehashes the map to the new capacity.
     *
     * @param newCapacity an <code>int</code> value
     */
	protected void rehash(int newCapacity) {
        
        int oldCapacity = _set.length;
        UnaryQuery<Procedure> oldKeys[] = _set;

        UnaryQuery<Procedure> newKeys[]  = (UnaryQuery<Procedure>[])Array.newInstance(UnaryQuery.class, newCapacity);

        for (int i = oldCapacity; i-- > 0;) {
            if(oldKeys[i] != null && oldKeys[i] != REMOVED) {
                UnaryQuery<Procedure> o = oldKeys[i];
                int index = insertionIndex2(o.id, newKeys);
                if (index < 0) {
                    throwObjectContractViolation(newKeys[(-index -1)], o);
                }
                newKeys[index] = o;
            }
        }
        
        _set = newKeys;
        
    }

    /**
     * retrieves the value for <tt>key</tt>
     *
     * @param key an <code>Object</code> value
     * @return the value of <tt>key</tt> or null if no such mapping exists.
     */
    final public UnaryQuery<Procedure> get(final int id) {
//        int index = index(id);
//        return index < 0 ? null : _set[index];
    	return index2(id);
    }

    /**
     * Deletes a key/value pair from the map.
     *
     * @param key an <code>Object</code> value
     * @return an <code>Object</code> value
     */
    public Object remove(final int id) {
        Object prev = null;
        int index = index(id);
        if (index >= 0) {
            prev = _set[index];
            removeAt(index);    // clear key,state; adjust size
        }
        return prev;
    }

    final public void values(int level, CacheCollectionResult result) {

        for (int i = _set.length; i-- > 0;) {
        	CacheEntryBase entry = _set[i];
            if(entry != null && entry != REMOVED) {
            	if(entry.getLevel() <= level)
            		result.add(entry);
            }
        }

    }
    
    final public ArrayList<CacheEntry> values() {

    	ArrayList<CacheEntry> result = new ArrayList<CacheEntry>();
    	
        for (int i = _set.length; i-- > 0;) {
            if(_set[i] != null && _set[i] != REMOVED) {
            	result.add(_set[i]);
            }
        }
    
    	return result;
    	
    }

} // THashMap
