package org.simantics.db.impl.query;

import org.simantics.db.exception.DatabaseException;

public class SuperRelationsFactory extends QueryFactoryBase {

    @Override
    public CacheEntryBase readKeyAndValue(QueryDeserializer deserializer) throws DatabaseException {
        SuperRelations result = reference(deserializer);
        IntSet ia = IntSet.deserialize(deserializer);
        result.setResult(ia);
        result.setReady();
        return result;
    }
    
    @Override
    public <T extends CacheEntryBase> T reference(QueryDeserializer deserializer) throws DatabaseException {
        return (T)deserializer.readSuperRelations();
    }

}
