/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.impl.query;

import java.io.InputStream;

import org.simantics.db.ObjectResourceIdMap;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.VirtualGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ResourceNotFoundException;
import org.simantics.db.impl.ClusterSupport;
import org.simantics.db.impl.graph.ReadGraphImpl;

public interface QuerySupport extends ResourceTranslator {

	Session getSession();

	ClusterSupport getClusterSupport();

	ObjectResourceIdMap<String> createChildMap();

	boolean isImmutable(int id);
	long getClusterId(int id);
	int getId(Resource resource);
	Resource getResource(int id);
	
    boolean resume(ReadGraphImpl graph);
	void dirtyPrimitives();
	void aboutToRead();
	
	int getSingleInstance(int subject);
	int getSingleSuperrelation(int subject);
	int getFunctionalObject(int subject, int predicate);
	boolean getObjects(ReadGraphImpl graph, int subject, int predicate, IntProcedure procedure) throws DatabaseException;
    
	org.simantics.db.DirectStatements getStatements(ReadGraphImpl graph, final int subject, QueryProcessor processor, boolean ignoreVirtual);
    
    void getPredicates(ReadGraphImpl graph, int subject, IntProcedure procedure) throws DatabaseException;
    byte[] getValue(ReadGraphImpl graph, int resource);
    InputStream getValueStream(ReadGraphImpl graph, int resource);
    
    void requestCluster(ReadGraphImpl graph, long clusterId, Runnable r);
    
    void ensureLoaded(final ReadGraphImpl graph, final int subject, final int predicate);
    void ensureLoaded(final ReadGraphImpl graph, final int subject);
    boolean isLoaded(int subject);
    
	int getBuiltin(String uri);

	@Deprecated // Use SerialisationSupport instead
	int getRandomAccessReference(String id) throws ResourceNotFoundException;

    void checkTasks();
    void ceased(int thread);
    Object getLock();
    
    VirtualGraph getProvider(int subject, int predicate, int object);
    VirtualGraph getProvider(int subject, int predicate);
    VirtualGraph getValueProvider(int subject);
    
    void exit(Throwable t);
    
}
