/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.impl.query;

import org.simantics.db.procedure.ListenerBase;

class ListenerEntry {
    
    public static final Object NO_VALUE = new Object() {
        
        public String toString() { return "NO_VALUE"; };
        
    };
    public static final Object NOT_CHANGED = new Object() {
      
        public String toString() { return "NOT_CHANGED"; };
        
    };
    
    public ListenerBase base;
    public Object procedure;
    public CacheEntry entry;
    
    private Object lastKnownResult;
    
    public ListenerEntry(CacheEntry entry, ListenerBase base, Object procedure) {
        this.entry = entry;
        this.base = base;
        this.procedure = procedure;
        if(entry.isReady()) {
            this.lastKnownResult = entry.getResult();
        } else {
            this.lastKnownResult = NO_VALUE;
        }
    }
    
    public void setLastKnown(Object object) {
    	lastKnownResult = object;
    }
    
    public Object getLastKnown() {
    	return lastKnownResult;
    }

    @Override
    public String toString() {
//    	return "[ListenerEntry last = " + lastKnownResult + ", procedure = " + procedure + "]";
    	return "[ListenerEntry " + ", procedure = " + procedure + " base=" + base + "]";
    }
    
    @Override
    public int hashCode() {
        return base.hashCode();
    }
    
	@Override
    public boolean equals(Object obj) {

        if(obj == this) return true;
        if(obj == null) return false;
        if(obj.getClass() != this.getClass()) return false;
        ListenerEntry other = (ListenerEntry)obj;
        return base.equals(other.base);
        
    }
    
}
