package org.simantics.db.impl;

import org.simantics.db.ReadGraph;
import org.simantics.db.RelationInfo;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.SyncProcedure;

public final class ForPossibleRelatedValueProcedure<T> implements SyncProcedure<T> {

	public final int predicateKey;
	public final int[] clusterKey;
	public final int[] predicateReference;
	public final RelationInfo info;
	public final ClusterI.CompleteTypeEnum completeType;
	private final SyncProcedure<T> user;
	
	public ForPossibleRelatedValueProcedure(int predicateKey, RelationInfo info, SyncProcedure<T> user) {
		this.predicateKey = predicateKey;
		this.completeType = ClusterTraitsBase.getCompleteTypeFromResourceKey(predicateKey); 
		this.info = info;
		this.user = user;
		this.clusterKey = new int[32*8];
		this.predicateReference = new int[32*8];
	}
	
	@Override
	public void execute(ReadGraph graph, T result) throws DatabaseException {
		user.execute(graph, result);
	}

	@Override
	public void exception(ReadGraph graph, Throwable throwable) throws DatabaseException {
		user.exception(graph, throwable);
	}
	
};
