/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.utils;

import java.util.Collections;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.utils.VersionInfo;
import org.simantics.db.common.utils.VersionMapRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.MapList;

public class VersionInfoRequest
extends ResourceRead<VersionInfo> {
    public VersionInfoRequest(Resource resource) {
        super(resource);
    }

    public VersionInfo perform(ReadGraph graph) throws DatabaseException {
        Resource parent;
        int pos;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        String baseName = (String)graph.getPossibleRelatedValue(this.resource, L0.HasName, (Binding)Bindings.STRING);
        String version = "";
        if (baseName != null && (pos = baseName.lastIndexOf(64)) != -1) {
            version = baseName.substring(pos + 1);
            baseName = baseName.substring(0, pos);
        }
        if ((parent = graph.getPossibleObject(this.resource, L0.PartOf)) != null) {
            MapList versionMap = (MapList)graph.syncRequest((Read)new VersionMapRequest(parent));
            return new VersionInfo(baseName, version, versionMap.getValues((Object)baseName));
        }
        return new VersionInfo(baseName, version, Collections.singleton(new NamedResource(version, this.resource)));
    }
}

