/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.request;

import java.util.HashMap;
import java.util.Map;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.ProcedureBarrier;
import org.simantics.db.procedure.AsyncMultiProcedure;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.layer0.Layer0;
import org.simantics.operation.Layer0X;

public class MappedPartsAsync extends ResourceAsyncRead<Map<Resource, Resource>> {

    public MappedPartsAsync(Resource realization) {
        super(realization);
    }
    
    @Override
    public void perform(AsyncReadGraph graph, final AsyncProcedure<Map<Resource, Resource>> procedure) {

    	final Layer0 L0 = graph.getService(Layer0.class);
    	final Layer0X L0X = graph.getService(Layer0X.class);
    	final HashMap<Resource, Resource> result = new HashMap<Resource, Resource>();
    	final ProcedureBarrier<Map<Resource, Resource>> ready = new ProcedureBarrier<Map<Resource, Resource>>(1);
    	
    	graph.forEachObject(resource, L0.ConsistsOf, new AsyncMultiProcedure<Resource>() {

			@Override
			public void execute(AsyncReadGraph graph, final Resource object) {
				
				ready.incrementAndGet();
				
				graph.forEachObject(object, L0X.Represents, new AsyncMultiProcedure<Resource>() {

					@Override
					public void execute(AsyncReadGraph graph, Resource mapped) {

						synchronized(result) {
							result.put(mapped, object);
						}

					}

					@Override
					public void finished(AsyncReadGraph graph) {

						ready.dec(graph, procedure, result);

					}

					@Override
					public void exception(AsyncReadGraph graph, Throwable throwable) {

						ready.except(throwable);
						ready.dec(graph, procedure, result);

					}

				});
				
			}

			@Override
			public void finished(AsyncReadGraph graph) {
				
				ready.dec(graph, procedure, result);
				
			}

			@Override
			public void exception(AsyncReadGraph graph, Throwable throwable) {
				
				ready.except(throwable);
				ready.dec(graph, procedure, result);
				
			}
    		
    	});
    	
    }
    
//    @Override
//    public Map<Resource, Resource> perform(ReadGraph graph) throws DatabaseException {
//        
//        Builtins b = graph.getBuiltins();
//        Map<Resource, Resource> result = new HashMap<Resource, Resource>();
//        
//        for(Resource part : graph.syncRequest(new ObjectsWithType(resource, b.ConsistsOf, resource2))) {
//        	Resource represents = graph.getPossibleObject(part, b.Represents);
//        	if(represents != null) result.put(represents, part);
//        }
//        
//        return result;
//        
//    }

}
