/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common;

public final class TestPolicy {
    public static final long TEST_EXIT_TIMEOUT; // Exit timeout in milliseconds.
    public static final boolean isActive() {
        return TEST_EXIT_TIMEOUT != 0;
    }
    public static final boolean waitExceeded(long waitTimeInSeconds) {
        if (TEST_EXIT_TIMEOUT == 0)
            return false;
        return TEST_EXIT_TIMEOUT <= waitTimeInSeconds * 1000;
    }
    static {
        String t = System.getProperty("test.exit.timeout");
        if (null != t)
            TEST_EXIT_TIMEOUT = Long.parseLong(t);
        else
            TEST_EXIT_TIMEOUT = 0;
    }
}
