/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.units.internal.deprecated;

public enum Magnitude {
	
	yotta("Y", 24, "yotta"),
	zetta("Z", 21, "zetta"),
	exa("E", 18, "exa"),
	peta("P", 15, "peta"),
	tera("T", 12, "tera"),
	giga("G", 9, "giga"),
	mega("M", 6, "mega"),
	kilo("k", 3, "kilo"),
	hecto("h", 2, "hecto"),
	deca("da", 1, "deca"),
	unscaled("", 0, ""),
	deci("d", -1, "deci"),
	centi("c", -2, "centi"),
	milli("m", -3, "milli"),
	micro("", -6, "micro"),
	nano("n", -9, "nano"),
	pico("p", -12, "pico"),
	femto("f", -15, "femto"),
	atto("a", -18, "atto"),
	zepto("z", -21, "zepto"),
	yocto("y", -24, "yocto")	
	;	
	
	String symbol;
	int exp;
	String name;
	
	private Magnitude(String symbol, int exp, String prefix) {
		this.symbol = symbol;
		this.exp = exp;
		this.name = prefix;
	}
	
	public String getPrefix() {
		return name;
	}
	
	@Override
	public String toString() {
		return name;
	}
	
	public int getExponent() {
		return exp;
	}
	
	/**
	 * Get most suitable magnitude for a value 
	 * 
	 * @param value
	 * @return suitable magnitude
	 */
	public static Magnitude getSuitable(double value)
	{
		double exp = Math.log10(value);
		for (Magnitude m : values()) {
			if (m.equals(hecto)||m.equals(deca)) continue;
			if (m.exp<exp)
				return m;
		}
		return yotta;
	}
	
		
}
