/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.binding.impl;

import org.simantics.databoard.binding.BooleanBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.error.UnsupportedOperationException;
import org.simantics.databoard.type.BooleanType;

/**
 * Binds Boolean Type to java.lang.Boolean-class. 
 *
 * @author Toni Kalajainen <toni.kalajainen@vtt.fi>
 */
public class BooleanBindingDefault extends BooleanBinding {

	public BooleanBindingDefault(BooleanType type) {
		super( type );
	}

	public Object create(boolean value) 
	{
		return value;
	}
	
	public Object create(Boolean value) 
	{
		return value;
	}

	public void setValue(Object obj, Boolean newValue) 
	throws BindingException
	{
		throw new UnsupportedOperationException("Cannot change the value of immutable java.lang.Boolean");
	}
	
	public void setValue(Object obj, boolean newValue) 
	throws BindingException
	{
		if (((Boolean)obj).booleanValue() == newValue) return;
		throw new UnsupportedOperationException("Cannot change the value of immutable java.lang.Boolean");
	}

	@Override
	public Boolean getValue(Object o) 
	throws BindingException
	{
		return ((Boolean)o);
	}
	
	@Override
	public boolean getValue_(Object o) 
	throws BindingException
	{
		return ((Boolean)o);
	}

    @Override
	public boolean isInstance(Object obj) {
		return obj instanceof Boolean;
	}
    
    @Override
    public boolean isImmutable() {
    	return true;
    }
	
}

