/*******************************************************************************
 * Copyright (c) 2007 VTT Technical Research Centre of Finland and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.binding.factory;

import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.error.RuntimeBindingConstructionException;
import org.simantics.databoard.type.Datatype;

public class SingleBindingScheme implements BindingScheme {

	Binding b;
	
	public SingleBindingScheme(Binding b) {
		this.b = b;
	}

	@Override
	public Binding getBinding(Datatype type)
			throws BindingConstructionException {
		if (type.equals(b.type())) return b;
		throw new BindingConstructionException(type+" is not supported");
	}

	@Override
	public Binding getBindingUnchecked(Datatype type)
			throws RuntimeBindingConstructionException {
		if (type.equals(b.type())) return b;
		throw new RuntimeBindingConstructionException(new BindingConstructionException(type+" is not supported"));
	}

	@Override
	public boolean supportsType(Datatype type) {
		return type.equals( b.type() );
	}

}

