/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.annotations;

import java.lang.annotation.Annotation;
import java.util.Arrays;

public class LengthImpl implements Length {
	
	int hash;
	String[] args;
	
	public LengthImpl(String...args) {
        hash = Arrays.hashCode(args);
		this.args = args;
	}

	@Override
	public Class<? extends Annotation> annotationType() {
		return Length.class;
	}

	@Override
	public String[] value() {
		return args;
	}	
	
	@Override
	public int hashCode() {
		return hash;
	}
	
	@Override
	public boolean equals(Object obj) {
		if (obj instanceof Length == false) return false;
		Length length = (Length) obj;
		return Arrays.equals( length.value(), args );
	}

}
