package org.simantics.databoard.adapter;


public abstract class AbstractAdapter implements Adapter {
	
	/** True if this adapter has to make type conversion (incl. sub-adapters) */
	boolean typeAdapter = false;		
	/** True if the adapter clones or creates a new instance (incl. all sub-adapters) */
	boolean clones = true;
	
	/**
	 * A back-reference to the adapter request for keeping adapters that are currently used
	 * from being unnecessarily purged from the cache.
	 */
	AdapterRequest request;
			
    public Object adaptUnchecked(Object obj) throws RuntimeAdaptException {
		try {
			return adapt(obj);
		} catch (AdaptException e) {
			throw new RuntimeAdaptException( e ); 
		}
    }
    
    public void finalizeConstruction() {}
    
}