/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.accessor.reference;

import org.simantics.databoard.util.URIUtil;


/**
 * Reference by name to a record field.
 * Format: "n-<name>"
 *
 * @author Toni Kalajainen <toni.kalajainen@vtt.fi>
 */
public class NameReference extends ChildReference {

	public String name;
	
	public NameReference(String name) {
		this.name = name;
	}
	
	public NameReference(String name, ChildReference child) {
		super(child);
		this.name = name;
	}
	
	public String getName() {
		return name;
	}
	
	@Override
	public String toString(boolean labelReference) {
		if (labelReference && (name.equals("uv") || name.equals("o") || name.equals("v"))) labelReference = false;
		String encoded = URIUtil.encodeURI(name);
		return labelReference ? encoded : "n-"+encoded; 
	}
	
	@Override
	public ChildReference clone() {
		return new NameReference(name, childReference==null ? null : childReference.clone());
	}	

	@Override
	public boolean equals(Object obj) {
		if (obj instanceof NameReference == false) return false;
		NameReference other = (NameReference) obj;
		if (!other.name.equals(name)) return false;
		if (other.hasChildReference() != hasChildReference()) return false;
		if (hasChildReference() && !other.childReference.equals(childReference)) return false;
		return true;
	}
	
	@Override
	public int hashCode() {
		int hash = 4665456 + 37 * name.hashCode();
		if (hasChildReference()) hash = 31*hash + childReference.hashCode();		
		return hash;
	}	
	
}

