/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.compressions.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

import org.simantics.compressions.CompressionCodec;

/**
 * @author Hannu Niemist&ouml;
 * @author Tuukka Lehtonen
 */
public abstract class CompressingCodecOutputStream extends CompressingOutputStream {

    CompressionCodec codec;

    public CompressingCodecOutputStream(CompressionCodec codec, File file) throws FileNotFoundException {
        this(codec, new FileOutputStream(file));
    }

    public CompressingCodecOutputStream(CompressionCodec codec, FileOutputStream stream) {
        this(codec, stream, stream.getChannel());
    }

    public CompressingCodecOutputStream(CompressionCodec codec, OutputStream stream, WritableByteChannel channel) {
        super(stream, channel);
        this.codec = codec;
    }

    protected int compressBound(int inputSize) {
        return codec.compressBound(inputSize);
    }

    protected int compress(ByteBuffer uncompressed, int uncompressedOffset, int uncompressedSize,
            ByteBuffer compressed, int compressedOffset) throws IOException {
        return codec.compressBuffer(uncompressed, uncompressedOffset, uncompressedSize, compressed, compressedOffset);
    }

}