/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.ui;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.State;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.simantics.charts.editor.TimeSeriesEditor;
import org.simantics.charts.ui.ChartLinkData;

public class LinkTimeHandler
extends AbstractHandler
implements IHandler,
IElementUpdater {
    public static final String COMMAND_ID = "org.simantics.charts.linktime";
    public static final String STATE_ID = "org.simantics.charts.linktime.state";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = service.getCommand(COMMAND_ID);
        State state = command.getState(STATE_ID);
        if (state != null) {
            ChartLinkData oldData = (ChartLinkData)state.getValue();
            if (oldData == null) {
                TimeSeriesEditor editor = this.getEditor(event);
                ChartLinkData currentData = new ChartLinkData();
                if (editor != null) {
                    editor.getFromEnd(currentData);
                }
                state.setValue((Object)currentData);
            } else {
                state.setValue(null);
            }
        }
        service.refreshElements(COMMAND_ID, null);
        return null;
    }

    TimeSeriesEditor getEditor(ExecutionEvent event) {
        IWorkbenchPart ap = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (ap instanceof TimeSeriesEditor) {
            return (TimeSeriesEditor)ap;
        }
        IWorkbenchWindow win = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        if (win == null) {
            return null;
        }
        IWorkbenchPage[] iWorkbenchPageArray = win.getPages();
        int n = iWorkbenchPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage page = iWorkbenchPageArray[n2];
            IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
            int n3 = iEditorReferenceArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IEditorReference ref = iEditorReferenceArray[n4];
                if (ref.getId().equals("org.simantics.charts.editor.timeseries")) {
                    IEditorPart part = ref.getEditor(false);
                    return (TimeSeriesEditor)part;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = service.getCommand(COMMAND_ID);
        State state = command.getState(STATE_ID);
        element.setChecked(state != null && state.getValue() != null);
    }
}

