package org.simantics.charts.ui;

import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.swt.SWT;
import org.simantics.browsing.ui.content.LabelDecorator;
import org.simantics.browsing.ui.model.labeldecorators.AbstractLabelDecorator;
import org.simantics.browsing.ui.model.labeldecorators.LabelDecorationRule;
import org.simantics.charts.ontology.ChartResource;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;

/**
 * Used for labeling both chart plots and subscription items.
 * 
 * @author Tuukka Lehtonen
 */
public class ChartItemLabelDecorationRule implements LabelDecorationRule {

    public static final ChartItemLabelDecorationRule INSTANCE = new ChartItemLabelDecorationRule();

    @Override
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class);
    }

    @Override
    public LabelDecorator getLabelDecorator(ReadGraph graph, Object content) throws DatabaseException {
        Resource item = (Resource) content;
        ChartResource CHART = ChartResource.getInstance(graph);

        Boolean hidden = graph.getPossibleRelatedValue(item, CHART.Chart_Item_hidden, Bindings.BOOLEAN);
        if (hidden == null || !hidden)
            return null;

        return HIDDEN_DECORATOR;
    }

    private static class HiddenLabelDecorator extends AbstractLabelDecorator {
        @SuppressWarnings("unchecked")
        @Override
        public <F> F decorateFont(F font, String column, int itemIndex) {
            return (F) ((FontDescriptor) font).withStyle(SWT.ITALIC);
        }
        @Override
        public String decorateLabel(String label, String column, int itemIndex) {
            return label + " (hidden)";
        }
    };

    private static HiddenLabelDecorator HIDDEN_DECORATOR = new HiddenLabelDecorator();

}