/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.ui.IViewPart;

public class ViewArgumentUtils {
    private static final Pattern argumentPattern = Pattern.compile("([^:&=]*)=([^:&=]*)");

    public static Map<String, String> parseViewArguments(IViewPart part) {
        String secondaryId = part.getViewSite().getSecondaryId();
        Map<String, String> result = ViewArgumentUtils.decodeArguments(secondaryId);
        return result;
    }

    public static Map<String, String> decodeArguments(String secondaryId) {
        String[] args;
        HashMap<String, String> result = new HashMap<String, String>();
        if (secondaryId == null) {
            return result;
        }
        String[] stringArray = args = secondaryId.split("&");
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            Matcher m = argumentPattern.matcher(arg);
            if (m.matches()) {
                String key = m.group(1);
                String value = m.group(2);
                key = ViewArgumentUtils.unescape(key);
                value = ViewArgumentUtils.unescape(value);
                result.put(key, value);
            }
            ++n2;
        }
        return result;
    }

    public static String encodeArguments(Map<String, String> args) {
        StringBuilder sb = new StringBuilder();
        boolean notFirst = false;
        for (Map.Entry<String, String> e : args.entrySet()) {
            if (notFirst) {
                sb.append("&");
            }
            notFirst = true;
            String key = e.getKey();
            String value = e.getValue();
            sb.append(ViewArgumentUtils.escape(key));
            sb.append("=");
            sb.append(ViewArgumentUtils.escape(value));
        }
        return sb.toString();
    }

    private static String escape(String s) {
        return s.replace("&", "%26").replace(":", "%3A").replace("=", "%3D");
    }

    private static String unescape(String s) {
        return s.replace("%26", "&").replace("%3A", ":").replace("%3D", "=");
    }
}

