/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt;

import java.util.ArrayList;
import java.util.Collection;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.common.NodeContextBuilder;
import org.simantics.browsing.ui.content.Viewpoint;
import org.simantics.browsing.ui.content.ViewpointFactory;
import org.simantics.browsing.ui.graph.impl.LazyViewpoint;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.ui.utils.ResourceAdaptionUtils;

public class ValuePropertyViewpointFactory
implements ViewpointFactory {
    public Viewpoint create(PrimitiveQueryUpdater provider, NodeContext context, BuiltinKeys.ViewpointKey key) {
        assert (provider != null);
        assert (context != null);
        return new LazyViewpoint(provider, context, key){

            public NodeContext[] children(ReadGraph graph) throws DatabaseException {
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                ResourceArray ra = ResourceAdaptionUtils.toSingleResourceArray((Object)this.context.getConstant(BuiltinKeys.INPUT));
                Collection children = graph.getObjects(ra.resources[0], L0.HasProperty);
                ArrayList<NodeContext> resultContexts = new ArrayList<NodeContext>();
                for (Resource child : children) {
                    if (!graph.isInstanceOf(child, L0.Literal)) continue;
                    resultContexts.add(NodeContextBuilder.buildWithInput((Object)child));
                }
                return resultContexts.toArray(new NodeContext[resultContexts.size()]);
            }

            public Boolean hasChildren(ReadGraph graph) throws DatabaseException {
                if (this.children(graph).length > 0) {
                    return true;
                }
                return false;
            }
        };
    }

    public String toString() {
        return "Scalar values";
    }
}

