/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt;

import java.util.List;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.Simantics;
import org.simantics.browsing.ui.swt.ModelledControl;
import org.simantics.browsing.ui.swt.stubs.BrowsingResource;
import org.simantics.browsing.ui.swt.widgets.Combo;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactory;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.utils.datastructures.Pair;

public class ModelledCombo
implements ModelledControl {
    private final Resource configuration;

    public ModelledCombo(Resource configuration) {
        this.configuration = configuration;
    }

    @Override
    public Control create(Composite parent, IWorkbenchSite site, ISessionContext context, WidgetSupport support) throws DatabaseException {
        Combo combo = new Combo(parent, support, 8);
        GridData gridData = (GridData)Simantics.getSession().syncRequest((Read)new Read<GridData>(){

            public GridData perform(ReadGraph graph) throws DatabaseException {
                Boolean grabExcessHorizontalSpace;
                BrowsingResource br = BrowsingResource.getInstance((ReadGraph)graph);
                GridData data = new GridData(4, 4, true, false);
                Integer span = (Integer)graph.getPossibleRelatedValue(ModelledCombo.this.configuration, br.Control_HorizontalSpan, (Binding)Bindings.INTEGER);
                if (span != null) {
                    data.horizontalSpan = span;
                }
                if ((grabExcessHorizontalSpace = (Boolean)graph.getPossibleRelatedValue(ModelledCombo.this.configuration, br.Control_HorizontalGrab, (Binding)Bindings.BOOLEAN)) != null) {
                    data.grabExcessHorizontalSpace = grabExcessHorizontalSpace;
                }
                return data;
            }
        });
        combo.setLayoutData(gridData);
        ReadFactory available = (ReadFactory)Simantics.getSession().syncRequest(new Read<ReadFactory<?, List<Pair<String, Object>>>>(){

            public ReadFactory<?, List<Pair<String, Object>>> perform(ReadGraph graph) throws DatabaseException {
                BrowsingResource br = BrowsingResource.getInstance((ReadGraph)graph);
                Resource factory = graph.getPossibleObject(ModelledCombo.this.configuration, br.Combo_AvailableItems);
                return (ReadFactory)graph.adapt(factory, ReadFactory.class);
            }
        });
        combo.setItemFactory2(available);
        ReadFactory selected = (ReadFactory)Simantics.getSession().syncRequest(new Read<ReadFactory<?, String>>(){

            public ReadFactory<?, String> perform(ReadGraph graph) throws DatabaseException {
                BrowsingResource br = BrowsingResource.getInstance((ReadGraph)graph);
                Resource factory = graph.getPossibleObject(ModelledCombo.this.configuration, br.Combo_SelectedItem);
                return (ReadFactory)graph.adapt(factory, ReadFactory.class);
            }
        });
        combo.setSelectionFactory(selected);
        ModifyListener modifier = (ModifyListener)Simantics.getSession().syncRequest((Read)new Read<ModifyListener>(){

            public ModifyListener perform(ReadGraph graph) throws DatabaseException {
                BrowsingResource br = BrowsingResource.getInstance((ReadGraph)graph);
                Resource factory = graph.getPossibleObject(ModelledCombo.this.configuration, br.Combo_Modifier);
                return (ModifyListener)graph.adapt(factory, ModifyListener.class);
            }
        });
        combo.addModifyListener(modifier);
        return combo.getWidget();
    }
}

