/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt;

import java.util.Map;
import java.util.Set;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.browsing.ui.Column;
import org.simantics.browsing.ui.graph.impl.GraphInputSources;
import org.simantics.browsing.ui.graph.impl.SessionContextInputSource;
import org.simantics.browsing.ui.swt.SimanticsDialog;
import org.simantics.browsing.ui.swt.widgets.GraphExplorerComposite;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.management.ISessionContext;
import org.simantics.utils.DataContainer;
import org.simantics.utils.datastructures.ArrayMap;

public abstract class GraphExplorerDialog2
extends SimanticsDialog {
    private final IWorkbenchSite site;
    private final DataContainer<Object[]> result = new DataContainer();
    private GraphExplorerComposite outputExplorer;

    public abstract Set<String> getBrowseContexts();

    public GraphExplorerDialog2(IWorkbenchSite site, String title) {
        super(Display.getCurrent().getActiveShell(), title);
        this.site = site;
    }

    Column[] getColumns() {
        return new Column[]{new Column("single", Column.Align.RIGHT, 180, "single", true, 1)};
    }

    @Override
    protected SessionContextInputSource getInputSource() {
        return GraphInputSources.projectSource();
    }

    protected boolean isResizable() {
        return true;
    }

    @Override
    protected void createControls(Composite body, ISessionContext context, WidgetSupport support) {
        this.outputExplorer = new GraphExplorerComposite((Map<String, Object>)ArrayMap.keys((Object[])new String[]{"displaySelectors", "displayFilter"}).values(new Object[]{false, false}), this.site, body, support, 2048);
        this.outputExplorer.setBrowseContexts(this.getBrowseContexts());
        this.outputExplorer.setColumnsVisible(false);
        this.outputExplorer.setColumns(this.getColumns());
        this.outputExplorer.finish();
        this.outputExplorer.setBackground(body.getDisplay().getSystemColor(5));
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).minSize(300, 400).applyTo((Control)this.outputExplorer);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            Tree tree = (Tree)this.outputExplorer.getExplorerControl();
            TreeItem[] selectedItems = tree.getSelection();
            Object[] res = new Object[selectedItems.length];
            int i = 0;
            while (i < selectedItems.length) {
                res[i] = selectedItems[i].getData();
                ++i;
            }
            this.result.set((Object)res);
        }
        super.buttonPressed(buttonId);
    }

    public Object[] getSelection() {
        return (Object[])this.result.get();
    }

    public GraphExplorerComposite getGraphExplorerComposite() {
        return this.outputExplorer;
    }
}

