/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.DataSource;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.common.EvaluatorData;
import org.simantics.browsing.ui.common.imagers.ContainerImager;
import org.simantics.browsing.ui.content.Imager;
import org.simantics.browsing.ui.content.ImagerFactory;
import org.simantics.browsing.ui.graph.impl.MissingImageDescriptor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.ui.icons.ImageDescriptorProvider;
import org.simantics.utils.datastructures.cache.ProvisionException;
import org.simantics.utils.ui.ErrorLogger;

public class AdapterImagerFactory
implements ImagerFactory {
    private final EvaluatorData.Transformer transformer;
    private final HashMap<String, Image> constants;
    private final String resourceColumn;

    public AdapterImagerFactory() {
        this(null);
    }

    public AdapterImagerFactory(EvaluatorData.Transformer transformer) {
        this(transformer, null, new HashMap<String, Image>(4));
    }

    public AdapterImagerFactory(EvaluatorData.Transformer transformer, String resourceColumn, HashMap<String, Image> constants) {
        this.transformer = transformer;
        this.constants = constants;
        this.resourceColumn = resourceColumn;
    }

    private Resource getInputResource(NodeContext context) {
        Object input = context.getConstant(BuiltinKeys.INPUT);
        if (this.transformer != null) {
            input = this.transformer.transform(input);
        }
        if (input instanceof Resource) {
            return (Resource)context.getConstant(BuiltinKeys.INPUT);
        }
        if (input instanceof IAdaptable) {
            return (Resource)((IAdaptable)input).getAdapter(Resource.class);
        }
        return null;
    }

    public Imager create(PrimitiveQueryUpdater updater, NodeContext context, BuiltinKeys.ImagerKey key) {
        ContainerImager result = new ContainerImager((Map)((HashMap)this.constants.clone()));
        result.setImage(this.resourceColumn, (Object)MissingImageDescriptor.getInstance());
        DataSource source = updater.getDataSource(ReadGraph.class);
        Resource inputResource = this.getInputResource(context);
        source.schedule(graph -> {
            ImageDescriptor image = null;
            Collection<Object> types = Collections.emptyList();
            try {
                types = graph.getPrincipalTypes(inputResource);
            }
            catch (DatabaseException databaseException) {
                ErrorLogger.defaultLogError((Throwable)databaseException);
            }
            for (Resource resource2 : types) {
                try {
                    ImageDescriptorProvider provider = (ImageDescriptorProvider)graph.getPossibleAdapter(resource2, ImageDescriptorProvider.class);
                    if (provider == null) continue;
                    try {
                        ImageDescriptor descriptor = (ImageDescriptor)provider.get();
                        if (descriptor == null) break;
                        image = descriptor;
                    }
                    catch (ProvisionException pe) {
                        ErrorLogger.defaultLogError((Throwable)pe);
                    }
                    break;
                }
                catch (DatabaseException e) {
                    ErrorLogger.defaultLogError((Throwable)e);
                }
            }
            result.setImage(this.resourceColumn, image);
            updater.scheduleReplace(context, (NodeContext.PrimitiveQueryKey)key, (Object)result);
        });
        return result;
    }
}

