/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt.widgets;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

import org.simantics.browsing.ui.swt.widgets.impl.ReadFactoryImpl;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.utils.datastructures.Quad;


public class VariableStringPropertyFactory extends ReadFactoryImpl<Variable, String> {

	final private String format;
	final private Collection<String> properties;
	
	public VariableStringPropertyFactory(String property) {
		this.properties = Collections.singleton(property);
		this.format = "%1";
	}

	public VariableStringPropertyFactory(String format, String ... properties) {
		this.properties = Arrays.asList(properties);
		this.format = format;
	}

	@Override
	public Object getIdentity(Object inputContents) {
		return new Quad<Variable, String, Collection<String>, Object>((Variable)inputContents, format, properties, getClass());
	}

	public String toString(ReadGraph graph, Variable variable, String property, Object value) throws DatabaseException {
//		System.out.println("toString " + value);
		if(value == null) {
			return "VariableStringPropertyFactory: no value for " + property + " in variable " + variable;//variable.getURI(graph);
		} else if(value instanceof Variable) {
			String result = ((Variable)value).getPossiblePropertyValue(graph, Variables.NAME);
//			System.out.println("toString[Variable] = " + result);
			return result;
		} else {
			return value.toString();
		}
	}
	
	public String toPossibleString(ReadGraph graph, Variable variable, String property, Object value) throws DatabaseException {
		if(value == null) return "";
		return toString(graph, variable, property, value);
	}

	@Override
	public String perform(ReadGraph graph, Variable variable) throws DatabaseException {

		if(variable == null) return "<Error: variable was null>";
		
		int index = 1;
		String result = format;
		for(String property : properties) {
//			System.out.println("variablestringpropertyfactory " + property);
			Variable target = variable.browsePossible(graph, property);
			Object targetValue = target != null ? target.getValue(graph) : null;
			String possibleTargetString = toPossibleString(graph, variable, property, targetValue);
			result = result.replace("?%" + (index), possibleTargetString);
			String targetString = toString(graph, variable, property, targetValue);
			result = result.replace("%" + (index), targetString);
			index++;
		}
		return result;
		
	}
	
}
