/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt.widgets;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.simantics.Simantics;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactory;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.request.ParametrizedRead;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.procedure.Listener;
import org.simantics.utils.ui.SWTUtils;

public class Text extends WidgetImpl {

	private ReadFactory<?, String> textFactory;
	
	final private org.eclipse.swt.widgets.Text text;
	
	public Text(Composite parent, WidgetSupport support, int style) {
		super(support);
		text = new org.eclipse.swt.widgets.Text(parent, style);
		support.register(this);
	}
	
	public void setTextFactory(ReadFactory<?, String> textFactory) {
		this.textFactory = textFactory;
	}
	
	public org.eclipse.swt.widgets.Text getWidget() {
		return text;
	}
	
	@Override
	public Control getControl() {
		return text;
	}

	@Override
	public void setInput(ISessionContext context, Object input) {

		if(textFactory != null) {
			textFactory.listen(context, input, new Listener<String>() {

				public void exception(final Throwable t) {
					SWTUtils.asyncExec(text, new Runnable() {

						@Override
						public void run() {
							if(isDisposed()) return;
//							System.out.println("Button received new text: " + text);
							text.setText(t.toString());
						}

					});
				}

				@Override
				public void execute(final String s) {
					SWTUtils.asyncExec(text, new Runnable() {

						@Override
						public void run() {
							if(isDisposed()) return;
							text.setText(s);
						}

					});
				}

				@Override
				public boolean isDisposed() {
					return text.isDisposed();
				}

			});
		
		}
		
	}
	
	public void setText(String s) {
		text.setText(s);
	}

    public <T> void setText(final ParametrizedRead<T, String> read) {
    	
    	Simantics.getSession().async(new UniqueRead<String>() {

    		@Override
    		public String perform(ReadGraph graph) throws DatabaseException {
    			T input = support.getInput(graph);
    			return graph.syncRequest(read.get(input));
    		}

    	}, new Listener<String>() {

    		@Override
    		public void exception(Throwable t) {
    			t.printStackTrace();
    		}

    		@Override
    		public void execute(final String _text) {

    			if(isDisposed()) return;

    			text.getDisplay().asyncExec(new Runnable() {

    				@Override
    				public void run() {
    					if(_text == null) text.setText("");
    					else text.setText(_text);
    				}

    			});
    		}

    		@Override
    		public boolean isDisposed() {
    			return text.isDisposed();
    		}

    	});

    }
	
}
