/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.jface.viewers.ISelection;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.ui.utils.ResourceAdaptionUtils;

/**
 * @author Tuukka Lehtonen
 */
public final class PropertyPageUtil {

    public static final int MAX_SELECTION_LENGTH_TO_SHOW = 5;

    public static String computeTitle(ReadGraph graph, ISelection selection) throws DatabaseException {
        boolean sameTypes = true;

        try {

            final ResourceArray[] ras = ResourceAdaptionUtils.toResourceArrays(selection);
            if (ras.length == 0)
                return null;

            // Check if all the input resource are of the same type.
            Collection<Resource> types = null;
            for (ResourceArray ra : ras) {
                if (ra.isEmpty()) {
                    return null;
                }
                if (types == null) {
                    types = graph.getPrincipalTypes(ra.resources[0]);
                } else {
                    Collection<Resource> ts = graph.getPrincipalTypes(ra.resources[0]);
                    ts.removeAll(types);
                    if (!ts.isEmpty()) {
                        sameTypes = false;
                        break;
                    }
                }
            }
            if (sameTypes) {
                // If the resource no longer exists, provide default name only.
                if (!graph.hasStatement(ras[0].resources[0])) {
                    return null;
                }

                String name = safeGetName(graph, ras[0].resources[0]);
                if (ras.length > 1)
                    name += " [" + ras.length +"]";
                return name;
            } else {
                Collection<String> names = new ArrayList<String>(ras.length);
                boolean truncate = ras.length > MAX_SELECTION_LENGTH_TO_SHOW;
                int end = Math.min(ras.length, MAX_SELECTION_LENGTH_TO_SHOW);
                int missing = ras.length - end;
                for (int i = 0; i < end; ++i) {
                    // If the resource no longer exists, provide default name only.
                    if (!graph.hasStatement(ras[i].resources[0]))
                        continue;

                    names.add(safeGetName(graph, ras[i].resources[0]));
                }
                if (names.isEmpty()) {
                    return null;
                }

                if (truncate)
                    names.add("+ " + missing + " more...");

                String name = names.toString();
                return name;
            }

        } catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
   }

    private static String safeGetName(ReadGraph g, Resource r) throws DatabaseException {
        return NameUtils.getSafeName(g, r);
//        try {
//            //System.out.println("safeGetName " + r);
//            return g.adapt(r, String.class);
//        } catch (AdaptionException e) {
//            return NameUtils.getSafeName(g, r);
//        }
    }

}