/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt;

import org.eclipse.ui.IWorkbenchSite;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;

public abstract class ModelledActionImpl<T> implements ModelledAction {

	@SuppressWarnings("unused")
    private Resource configuration;
	private WidgetSupport support;
	
	public ModelledActionImpl(Resource configuration) {
		this.configuration = configuration;
	}
	
	public abstract void run(T input);

	@SuppressWarnings("unchecked")
	protected <T2> T2 getParameter(String uri) {
		
		return (T2)support.getParameter(uri);		
		
	}
	
	@Override
	public Runnable create(IWorkbenchSite site, ISessionContext context, final WidgetSupport support) throws DatabaseException {
	
		this.support = support;
		
		return new Runnable() {

			@Override
			public void run() {
				@SuppressWarnings("unchecked")
				T input = (T)support.getInput();
				
				ModelledActionImpl.this.run(input);
			}
			
		};
		
	}
	
}
