/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt;

import java.net.URL;

import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.browsing.ui.common.imagers.ImageURLs;
import org.simantics.browsing.ui.content.Imager;

/**
 * @author Antti Villberg
 * 
 */
public class ImageURLsImager<Image> implements Imager {

    private final ImageURLs          urls;

    public ImageURLsImager(ImageURLs urls) {
        this.urls = urls;
    }

    @SuppressWarnings("unchecked")
    @Override
    public Image getImage(String key) {
        URL url = urls.getURL(key);
        if(url == null) return null;
        else {
            ImageDescriptor desc = ImageDescriptor.createFromURL(url);
            return (Image) desc;
        }
    }

}
